/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalbreaker;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerDescriptor;
import mods.eln.sixnode.electricalbreaker.ElectricalBreakerGui;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalBreakerRender
extends SixNodeElementRender {
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    ElectricalBreakerDescriptor descriptor;
    long time;
    RcInterpolator interpol;
    float uMin;
    float uMax;
    boolean boot = true;
    float switchAlpha = 0.0f;
    public boolean switchState;
    CableRenderDescriptor cableRender;

    public ElectricalBreakerRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalBreakerDescriptor)descriptor;
        this.time = System.currentTimeMillis();
        this.interpol = new RcInterpolator(this.descriptor.speed);
    }

    @Override
    public void draw() {
        super.draw();
        this.front.glRotateOnX();
        this.descriptor.draw(this.interpol.get(), UtilsClient.distanceFromClientPlayer(this.tileEntity));
    }

    @Override
    public void refresh(float deltaT) {
        this.interpol.setTarget(this.switchState ? 1.0f : 0.0f);
        this.interpol.step(deltaT);
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return this.cableRender;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        Utils.println("Front : " + (Object)((Object)this.front));
        try {
            this.switchState = stream.readBoolean();
            this.uMax = stream.readFloat();
            this.uMin = stream.readFloat();
            ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(Utils.unserialiseItemStack(stream), ElectricalCableDescriptor.class);
            this.cableRender = desc == null ? null : desc.render;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.boot) {
            this.interpol.setValue(this.switchState ? 1.0f : 0.0f);
        }
        this.boot = false;
    }

    public void clientSetVoltageMin(float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(2);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientSetVoltageMax(float value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(1);
            stream.writeFloat(value);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clientToogleSwitch() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(3);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalBreakerGui(player, this.inventory, this);
    }
}

