/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalcable;

import java.util.Collections;
import java.util.List;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalcable.ElectricalCableElement;
import mods.eln.sixnode.electricalcable.ElectricalCableRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ElectricalCableDescriptor
extends SixNodeDescriptor {
    double electricalNominalRs;
    public double electricalNominalVoltage;
    public double electricalNominalPower;
    public double electricalNominalPowerDropFactor;
    public boolean signalWire;
    public double electricalMaximalVoltage;
    public double electricalMaximalCurrent;
    public double electricalRp = Double.POSITIVE_INFINITY;
    public double electricalRs = Double.POSITIVE_INFINITY;
    public double electricalC = 1.0;
    public double thermalRp = 1.0;
    public double thermalRs = 1.0;
    public double thermalC = 1.0;
    public double thermalWarmLimit = 100.0;
    public double thermalCoolLimit = -100.0;
    double electricalMaximalI;
    public double electricalRsMin = 0.0;
    public double electricalRsPerCelcius = 0.0;
    public double dielectricBreakOhmPerVolt = 0.0;
    public double dielectricBreakOhm = Double.POSITIVE_INFINITY;
    public double dielectricVoltage = Double.POSITIVE_INFINITY;
    public double dielectricBreakOhmMin = Double.POSITIVE_INFINITY;
    String description = "todo cable";
    public CableRenderDescriptor render;

    public ElectricalCableDescriptor(String name, CableRenderDescriptor render, String description, boolean signalWire) {
        super(name, ElectricalCableElement.class, ElectricalCableRender.class);
        this.description = description;
        this.render = render;
        this.signalWire = signalWire;
    }

    public void setPhysicalConstantLikeNormalCable(double electricalNominalVoltage, double electricalNominalPower, double electricalNominalPowerDropFactor, double electricalMaximalVoltage, double electricalMaximalPower, double electricalOverVoltageStartPowerLost, double thermalWarmLimit, double thermalCoolLimit, double thermalNominalHeatTime, double thermalConductivityTao) {
        this.electricalNominalVoltage = electricalNominalVoltage;
        this.electricalNominalPower = electricalNominalPower;
        this.electricalNominalPowerDropFactor = electricalNominalPowerDropFactor;
        this.thermalWarmLimit = thermalWarmLimit;
        this.thermalCoolLimit = thermalCoolLimit;
        this.electricalMaximalVoltage = electricalMaximalVoltage;
        this.electricalRp = 1.0E9;
        double electricalNorminalI = electricalNominalPower / electricalNominalVoltage;
        this.electricalRs = this.electricalNominalRs = electricalNominalPower * electricalNominalPowerDropFactor / electricalNorminalI / electricalNorminalI / 2.0;
        this.electricalMaximalI = electricalMaximalPower / electricalNominalVoltage;
        double thermalMaximalPowerDissipated = this.electricalMaximalI * this.electricalMaximalI * this.electricalRs * 2.0;
        this.thermalC = thermalMaximalPowerDissipated * thermalNominalHeatTime / thermalWarmLimit;
        this.thermalRp = thermalWarmLimit / thermalMaximalPowerDissipated;
        this.thermalRs = thermalConductivityTao / this.thermalC / 2.0;
        Eln.simulator.checkThermalLoad(this.thermalRs, this.thermalRp, this.thermalC);
        this.electricalRsMin = this.electricalNominalRs;
        this.electricalRsPerCelcius = 0.0;
        this.dielectricBreakOhmPerVolt = 0.95;
        this.dielectricBreakOhm = electricalMaximalVoltage * electricalMaximalVoltage / electricalOverVoltageStartPowerLost;
        this.dielectricVoltage = electricalMaximalVoltage;
        this.dielectricBreakOhmMin = this.dielectricBreakOhm;
        this.electricalMaximalCurrent = electricalMaximalPower / electricalNominalVoltage;
        this.voltageLevelColor = VoltageLevelColor.fromCable(this);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
        if (this.signalWire) {
            Data.addSignal(this.newItemStack());
        }
    }

    public void applyTo(ElectricalLoad electricalLoad, double rsFactor) {
        electricalLoad.setRs(this.electricalRs * rsFactor);
    }

    public void applyTo(ElectricalLoad electricalLoad) {
        this.applyTo(electricalLoad, 1.0);
    }

    public void applyTo(Resistor resistor) {
        this.applyTo(resistor, 1.0);
    }

    public void applyTo(Resistor resistor, double factor) {
        resistor.setR(this.electricalRs * factor);
    }

    public void applyTo(ThermalLoad thermalLoad) {
        thermalLoad.Rs = this.thermalRs;
        thermalLoad.C = this.thermalC;
        thermalLoad.Rp = this.thermalRp;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.signalWire) {
            Collections.addAll(list, I18N.tr("Cable is adapted to conduct\nelectrical signals.", new Object[0]).split("\n"));
            Collections.addAll(list, I18N.tr("A signal is electrical information\nwhich must be between 0V and %1$V", 50.0).split("\n"));
            list.add(I18N.tr("Not adapted to transport power.", new Object[0]));
        } else {
            list.add(I18N.tr("Save usage:", new Object[0]));
            list.add("  " + I18N.tr("Voltage: %1$V", (int)this.electricalNominalVoltage));
            list.add("  " + I18N.tr("Current: %1$A", this.electricalNominalPower / this.electricalNominalVoltage));
            list.add("  " + I18N.tr("Power: %1$W", (int)this.electricalNominalPower));
            list.add("  " + I18N.tr("Serial resistance: %1$\u2126", this.electricalNominalRs * 2.0));
        }
    }

    public int getNodeMask() {
        if (this.signalWire) {
            return 4;
        }
        return 1;
    }

    public static CableRenderDescriptor getCableRender(ItemStack cable) {
        if (cable == null) {
            return null;
        }
        GenericItemBlockUsingDamageDescriptor desc = ElectricalCableDescriptor.getDescriptor(cable);
        if (desc instanceof ElectricalCableDescriptor) {
            return ((ElectricalCableDescriptor)desc).render;
        }
        return null;
    }

    public void bindCableTexture() {
        this.render.bindCableTexture();
    }
}

