/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldatalogger;

import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class DataLogs
implements INBTTReady {
    byte[] log;
    int sizeMax;
    int size;
    float samplingPeriod = 0.5f;
    float maxValue = 100.0f;
    float minValue = 0.0f;
    byte unitType = (byte)4;
    static final byte voltageType = 0;
    static final byte currentType = 1;
    static final byte powerType = 2;
    static final byte celsiusType = 3;
    static final byte percentType = 4;
    static final byte energyType = 5;

    public DataLogs(int sizeMax) {
        this.log = new byte[sizeMax];
        this.sizeMax = sizeMax;
        this.size = 0;
    }

    void write(byte data) {
        if (this.size != this.sizeMax) {
            ++this.size;
        }
        for (int idx = this.size != this.sizeMax ? this.size : this.size - 1; idx > 0; --idx) {
            this.log[idx] = this.log[idx - 1];
        }
        this.log[0] = data;
    }

    void reset() {
        this.size = 0;
    }

    int size() {
        return this.size;
    }

    byte read(int idx) {
        return this.log[idx];
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        byte[] cpy = nbt.func_74770_j(str + "log");
        Utils.println("Datalog readnbt " + cpy.length);
        for (int idx = 0; idx < cpy.length; ++idx) {
            this.write(cpy[cpy.length - 1 - idx]);
        }
        this.samplingPeriod = nbt.func_74760_g(str + "samplingPeriod");
        this.maxValue = nbt.func_74760_g(str + "maxValue");
        this.minValue = nbt.func_74760_g(str + "minValue");
        this.unitType = nbt.func_74771_c(str + "unitType");
        Utils.println("Datalog readnbt done");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74773_a(str + "log", this.copyLog());
        nbt.func_74776_a(str + "samplingPeriod", this.samplingPeriod);
        nbt.func_74776_a(str + "maxValue", this.maxValue);
        nbt.func_74776_a(str + "minValue", this.minValue);
        nbt.func_74774_a(str + "unitType", this.unitType);
    }

    public byte[] copyLog() {
        byte[] cpy = new byte[this.size];
        for (int idx = 0; idx < this.size; ++idx) {
            cpy[idx] = this.read(idx);
        }
        return cpy;
    }

    public String toString() {
        String str = "";
        for (int idx = 0; idx < this.size; ++idx) {
            str = str + (this.read(idx) + 128) + " ";
        }
        return str;
    }

    void draw(float margeX, float margeY, String textHeader) {
        DataLogs.draw(this.log, this.size, this.samplingPeriod, this.maxValue, this.minValue, this.unitType, margeX, margeY, textHeader);
    }

    static void draw(byte[] value, int size, float samplingPeriod, float maxValue, float minValue, byte unitType, float margeX, float margeY, String textHeader) {
        int idx;
        if (value == null) {
            return;
        }
        if (size < 2) {
            return;
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        float dx = 1.0f / (float)(size - 1);
        GL11.glBegin((int)3);
        for (idx = 0; idx < size; ++idx) {
            GL11.glVertex2f((float)(margeX - dx * (float)idx * margeX), (float)(margeY - (float)(value[idx] + 128) / 255.0f * margeY));
        }
        GL11.glEnd();
        GL11.glBegin((int)8);
        for (idx = 0; idx < size; ++idx) {
            float x = margeX - dx * (float)idx * margeX;
            float y = margeY - (float)(value[idx] + 128) / 255.0f * margeY;
            GL11.glVertex2f((float)x, (float)(y + 0.01f));
            GL11.glVertex2f((float)x, (float)(y - 0.01f));
        }
        GL11.glEnd();
        float temp = 0.01f;
        GL11.glBegin((int)8);
        GL11.glVertex2f((float)(margeX + temp), (float)0.0f);
        GL11.glVertex2f((float)(margeX - temp), (float)0.0f);
        GL11.glVertex2f((float)(margeX + temp), (float)(margeY + temp));
        GL11.glVertex2f((float)(margeX - temp), (float)(margeY - temp));
        GL11.glVertex2f((float)0.0f, (float)(margeY + temp));
        GL11.glVertex2f((float)0.0f, (float)(margeY - temp));
        GL11.glEnd();
        if (minValue < 0.0f && maxValue > 0.0f || minValue > 0.0f && maxValue < 0.0f) {
            temp = 0.005f;
            float zeroY = maxValue / (maxValue - minValue) * margeY;
            GL11.glBegin((int)8);
            GL11.glVertex2f((float)margeX, (float)(zeroY + temp));
            GL11.glVertex2f((float)margeX, (float)(zeroY - temp));
            GL11.glVertex2f((float)0.0f, (float)(zeroY + temp));
            GL11.glVertex2f((float)0.0f, (float)(zeroY - temp));
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        float scale = 0.01f;
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        fontrenderer.func_78276_b(textHeader + " " + DataLogs.getYstring(1.0f, maxValue, minValue, unitType), (int)(margeX / scale), (int)(0.0f / scale), 0);
        fontrenderer.func_78276_b(textHeader + " " + DataLogs.getYstring(0.5f, maxValue, minValue, unitType), (int)(margeX / scale), (int)((margeY / 2.0f - 0.05f) / scale), 0);
        fontrenderer.func_78276_b(textHeader + " " + DataLogs.getYstring(0.0f, maxValue, minValue, unitType), (int)(margeX / scale), (int)((margeY - 0.08f) / scale), 0);
        fontrenderer.func_78276_b(textHeader + Utils.plotTime((float)size * samplingPeriod), (int)(0.0f / scale), (int)(((double)margeY + 0.03) / (double)scale), 0);
        fontrenderer.func_78276_b(textHeader + Utils.plotTime(0.0), (int)(((double)margeX - 0.05) / (double)scale), (int)(((double)margeY + 0.03) / (double)scale), 0);
        GL11.glPopMatrix();
    }

    public static String getYstring(float factor, float maxValue, float minValue, byte unitType) {
        String str = "";
        switch (unitType) {
            case 3: {
                str = Utils.plotCelsius("", (double)(factor * (maxValue - minValue) + minValue) - 20.0);
                break;
            }
            case 0: {
                str = Utils.plotVolt("", factor * (maxValue - minValue) + minValue);
                break;
            }
            case 1: {
                str = Utils.plotAmpere("", factor * (maxValue - minValue) + minValue);
                break;
            }
            case 2: {
                str = Utils.plotPower("", factor * (maxValue - minValue) + minValue);
                break;
            }
            case 4: {
                str = Utils.plotPercent("", (double)(factor * (maxValue - minValue) + minValue) * 0.01);
                break;
            }
            case 5: {
                str = Utils.plotEnergy("", factor * (maxValue - minValue) + minValue);
            }
        }
        return str;
    }

    public static void draw(NBTTagCompound nbt, float margeX, float margeY, String textHeader) {
        if (nbt == null) {
            return;
        }
        byte[] data = nbt.func_74770_j("log");
        if (data == null) {
            return;
        }
        DataLogs.draw(data, data.length, nbt.func_74760_g("samplingPeriod"), nbt.func_74760_g("maxValue"), nbt.func_74760_g("minValue"), nbt.func_74771_c("unitType"), margeX, margeY, textHeader);
    }
}

