/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldatalogger;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerElement;
import net.minecraft.item.ItemStack;

public class ElectricalDataLoggerProcess
implements IProcess {
    ElectricalDataLoggerElement e;

    public ElectricalDataLoggerProcess(ElectricalDataLoggerElement e) {
        this.e = e;
    }

    @Override
    public void process(double time) {
        byte value;
        if (!this.e.pause) {
            this.e.timeToNextSample -= time;
            value = (byte)(this.e.inputGate.getNormalized() * 255.5 - 128.0);
            this.e.sampleStack += value;
            ++this.e.sampleStackNbr;
        }
        if (this.e.printToDo) {
            ItemStack paperStack = this.e.inventory.func_70301_a(0);
            ItemStack printStack = this.e.inventory.func_70301_a(1);
            if (paperStack != null && printStack == null) {
                this.e.inventory.func_70298_a(0, 1);
                ItemStack print = Eln.instance.dataLogsPrintDescriptor.newItemStack(1);
                Eln.instance.dataLogsPrintDescriptor.initializeStack(print, this.e.logs);
                this.e.inventory.func_70299_a(1, print);
            }
            this.e.printToDo = false;
        }
        if (this.e.timeToNextSample <= 0.0) {
            this.e.timeToNextSample += (double)this.e.logs.samplingPeriod;
            value = (byte)(this.e.sampleStack / this.e.sampleStackNbr);
            this.e.sampleStackReset();
            this.e.logs.write(value);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
            DataOutputStream packet = new DataOutputStream(bos);
            this.e.preparePacketForClient(packet);
            try {
                packet.writeByte(2);
                packet.write(value);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.e.sendPacketToAllClient(bos);
        }
    }
}

