/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaldatalogger;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricaldatalogger.DataLogs;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerDescriptor;
import mods.eln.sixnode.electricaldatalogger.ElectricalDataLoggerGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class ElectricalDataLoggerRender
extends SixNodeElementRender {
    SixNodeElementInventory inventory = new SixNodeElementInventory(2, 64, this);
    ElectricalDataLoggerDescriptor descriptor;
    long time;
    public boolean pause;
    DataLogs log = new DataLogs(256);
    boolean waitFistSync = true;

    public ElectricalDataLoggerRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalDataLoggerDescriptor)descriptor;
        this.time = System.currentTimeMillis();
        this.clientSend(5);
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }

    @Override
    public void draw() {
        super.draw();
        if (!this.descriptor.onFloor) {
            if (this.side.isY()) {
                GL11.glPushMatrix();
                this.front.right().glRotateOnX();
                this.drawSignalPin(LRDU.Right, new float[]{0.0f, 5.67f, 0.0f, 0.0f});
                GL11.glPopMatrix();
            } else {
                this.drawSignalPin(this.front.inverse(), new float[]{6.37f, 6.37f, 5.67f, 6.12f});
            }
        }
        this.descriptor.draw(this.log, this.side, this.front, this.tileEntity.field_145851_c, this.tileEntity.field_145849_e);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.log.unitType = stream.readByte();
            this.pause = stream.readBoolean();
            this.log.samplingPeriod = stream.readFloat();
            this.log.maxValue = stream.readFloat();
            this.log.minValue = stream.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) throws IOException {
        byte header = stream.readByte();
        switch (header) {
            case 1: 
            case 2: {
                if (header == 1) {
                    this.log.reset();
                    this.waitFistSync = false;
                }
                for (int size = stream.available(); size != 0; --size) {
                    this.log.write(stream.readByte());
                }
                break;
            }
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalDataLoggerGui(player, this.inventory, this);
    }
}

