/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalentitysensor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.EntitySensorFilterDescriptor;
import mods.eln.misc.Coordonate;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricalentitysensor.ElectricalEntitySensorElement;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ElectricalEntitySensorSlowProcess
implements IProcess,
INBTTReady {
    ElectricalEntitySensorElement element;
    double timeCounter = 0.0;
    static final double refreshPeriode = 0.2;
    RcInterpolator rc1 = new RcInterpolator(0.4f);
    RcInterpolator rc2 = new RcInterpolator(0.4f);
    boolean oldState = false;
    boolean state = false;
    HashMap<Object, Vec3> lastEPos = new HashMap();

    public ElectricalEntitySensorSlowProcess(ElectricalEntitySensorElement element) {
        this.element = element;
    }

    @Override
    public void process(double time) {
        this.timeCounter += time;
        if (this.timeCounter > 0.2) {
            GenericItemUsingDamageDescriptor gen;
            this.timeCounter -= 0.2;
            boolean useSpeed = this.element.descriptor.useEntitySpeed;
            double speedFactor = this.element.descriptor.speedFactor;
            Coordonate coord = this.element.sixNode.coordonate;
            ItemStack filterStack = this.element.inventory.func_70301_a(0);
            Class filterClass = EntityLivingBase.class;
            if (filterStack != null && (gen = EntitySensorFilterDescriptor.getDescriptor(filterStack)) != null && gen instanceof EntitySensorFilterDescriptor) {
                EntitySensorFilterDescriptor filter = (EntitySensorFilterDescriptor)gen;
                filterClass = filter.entityClass;
            }
            World world = coord.world();
            double rayMax = this.element.descriptor.maxRange;
            AxisAlignedBB bb = coord.getAxisAlignedBB((int)rayMax);
            List list = world.func_72872_a(filterClass, bb);
            double output = 0.0;
            for (Object o : list) {
                Entity e = (Entity)o;
                Vec3 lastPos = this.lastEPos.get(e);
                if (lastPos != null) {
                    double weight = 0.4;
                    ArrayList<Block> blockList = Utils.traceRay(world, (double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v);
                    boolean view = true;
                    for (Block b : blockList) {
                        if (!b.func_149662_c()) continue;
                        view = false;
                        break;
                    }
                    if (view) {
                        double distance;
                        if (e instanceof EntityPlayerMP) {
                            weight *= 2.0;
                        }
                        if ((distance = Utils.getLength((double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) < rayMax) {
                            double sf = 1.0;
                            if (useSpeed) {
                                sf = speedFactor * Utils.getLength(e.field_70165_t, e.field_70163_u, e.field_70161_v, lastPos.field_72450_a, lastPos.field_72448_b, lastPos.field_72449_c);
                            }
                            output += sf * weight * (rayMax - distance) / rayMax;
                        }
                    }
                }
                output = Math.min(1.0, output);
                this.lastEPos.put(e, Vec3.func_72443_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v));
            }
            this.rc1.setTarget((float)output);
        }
        this.rc1.step((float)time);
        this.rc2.setTarget(this.rc1.get());
        this.rc2.step((float)time);
        this.element.outputGateProcess.setOutputNormalized(this.rc2.get());
        boolean bl = this.state = this.element.outputGateProcess.getOutputNormalized() > 0.6;
        if (this.state != this.oldState) {
            this.element.needPublish();
        }
        this.oldState = this.state;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.rc1.readFromNBT(nbt, str + "rc1");
        this.rc2.readFromNBT(nbt, str + "rc2");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        this.rc1.writeToNBT(nbt, str + "rc1");
        this.rc2.writeToNBT(nbt, str + "rc2");
    }
}

