/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalfiredetector;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorContainer;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorDescriptor;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

public class ElectricalFireDetectorElement
extends SixNodeElement {
    ElectricalFireDetectorDescriptor descriptor;
    public NbtElectricalGateOutput outputGate;
    public NbtElectricalGateOutputProcess outputGateProcess;
    public ElectricalFireDetectorSlowProcess slowProcess;
    public boolean powered;
    public boolean firePresent = false;
    SixNodeElementInventory inventory;

    public ElectricalFireDetectorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalFireDetectorDescriptor)descriptor;
        this.slowProcess = new ElectricalFireDetectorSlowProcess(this);
        if (!this.descriptor.batteryPowered) {
            this.powered = true;
            this.outputGate = new NbtElectricalGateOutput("outputGate");
            this.outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
            this.electricalLoadList.add(this.outputGate);
            this.electricalComponentList.add(this.outputGateProcess);
        } else {
            this.powered = false;
            this.inventory = new SixNodeElementInventory(1, 64, this);
        }
        this.slowProcessList.add(this.slowProcess);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (!this.descriptor.batteryPowered && this.front == lrdu.left()) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (!this.descriptor.batteryPowered && this.front == lrdu.left()) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        if (this.descriptor.batteryPowered) {
            return I18N.tr("Fire detected: ", new Object[0]) + this.firePresent;
        }
        return Utils.plotVolt("U:", this.outputGate.getU()) + Utils.plotAmpere("I:", this.outputGate.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.powered);
            stream.writeBoolean(this.firePresent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return this.descriptor.batteryPowered;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected void inventoryChanged() {
        super.inventoryChanged();
        this.needPublish();
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new ElectricalFireDetectorContainer(player, this.inventory);
    }
}

