/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalfiredetector;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorDescriptor;
import mods.eln.sixnode.electricalfiredetector.ElectricalFireDetectorGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalFireDetectorRender
extends SixNodeElementRender {
    ElectricalFireDetectorDescriptor descriptor;
    boolean powered = false;
    boolean firePresent = false;
    boolean ledOn = false;
    SixNodeElementInventory inventory;
    float time = 0.0f;

    public ElectricalFireDetectorRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalFireDetectorDescriptor)descriptor;
        if (this.descriptor.batteryPowered) {
            this.inventory = new SixNodeElementInventory(1, 64, this);
        }
    }

    @Override
    public void draw() {
        super.draw();
        if (!this.descriptor.batteryPowered) {
            this.drawSignalPin(this.front.right(), this.descriptor.pinDistance);
        }
        this.descriptor.draw(this.ledOn);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.powered = stream.readBoolean();
            this.firePresent = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void refresh(float deltaT) {
        this.time += deltaT;
        this.ledOn = this.powered ? (this.firePresent ? this.firePresent : (int)(this.time * 5.0f) % 25 == 0) : false;
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalFireDetectorGui(player, this.inventory, this);
    }
}

