/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalgatesource;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceDescriptor;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalGateSourceElement
extends SixNodeElement {
    public ElectricalGateSourceDescriptor descriptor;
    public NbtElectricalLoad outputGate = new NbtElectricalLoad("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public AutoResetProcess autoResetProcess;
    public static final byte setVoltagerId = 1;

    public ElectricalGateSourceElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalGateSourceDescriptor)descriptor;
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        if (this.descriptor.autoReset) {
            this.autoResetProcess = new AutoResetProcess();
            this.slowProcessList.add(this.autoResetProcess);
            this.autoResetProcess.reset();
        }
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.outputGate.getU(), this.outputGate.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.front.toInt() << 4);
            stream.writeFloat((float)this.outputGateProcess.getU());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.instance.signalCableDescriptor.applyTo(this.outputGate);
        this.computeElectricalLoad();
    }

    @Override
    protected void inventoryChanged() {
        this.computeElectricalLoad();
    }

    public void computeElectricalLoad() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        if (!Utils.playerHasMeter(entityPlayer) && this.descriptor.onOffOnly) {
            this.outputGateProcess.state(!this.outputGateProcess.getOutputOnOff());
            this.play(new SoundCommand("random.click").mulVolume(0.3f, 0.6f).smallRange());
            if (this.autoResetProcess != null) {
                this.autoResetProcess.reset();
            }
            this.needPublish();
            return true;
        }
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.outputGateProcess.setU(stream.readFloat());
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return !this.descriptor.onOffOnly;
    }

    class AutoResetProcess
    implements IProcess {
        double timeout = 0.0;
        double timeoutDelay = 0.21;

        AutoResetProcess() {
        }

        @Override
        public void process(double time) {
            if (this.timeout > 0.0) {
                if (this.timeout - time < 0.0) {
                    ElectricalGateSourceElement.this.outputGateProcess.setOutputNormalized(0.0);
                    ElectricalGateSourceElement.this.needPublish();
                }
                this.timeout -= time;
            }
        }

        void reset() {
            this.timeout = this.timeoutDelay;
        }
    }
}

