/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalgatesource;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.RcInterpolator;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceDescriptor;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalGateSourceRender
extends SixNodeElementRender {
    ElectricalGateSourceDescriptor descriptor;
    LRDU front;
    RcInterpolator interpolator;
    float voltageSyncValue = 0.0f;
    boolean voltageSyncNew = false;
    boolean boot = true;

    public ElectricalGateSourceRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalGateSourceDescriptor)descriptor;
        this.interpolator = new RcInterpolator(this.descriptor.render.speed);
    }

    @Override
    public void draw() {
        super.draw();
        this.drawSignalPin(this.front, new float[]{3.0f, 3.0f, 3.0f, 3.0f});
        if (this.side.isY()) {
            this.front.glRotateOnX();
        } else {
            LRDU.Down.glRotateOnX();
        }
        this.descriptor.draw(this.interpolator.get(), UtilsClient.distanceFromClientPlayer(this.tileEntity), this.tileEntity);
    }

    @Override
    public void refresh(float deltaT) {
        this.interpolator.setTarget((float)((double)this.voltageSyncValue / 50.0));
        this.interpolator.step(deltaT);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.front = LRDU.fromInt(b >> 4 & 3);
            float readF = stream.readFloat();
            if (this.voltageSyncValue != readF) {
                this.voltageSyncValue = readF;
                this.voltageSyncNew = true;
            }
            if (this.boot) {
                this.boot = false;
                this.interpolator.setValue((float)((double)this.voltageSyncValue / 50.0));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalGateSourceGui(player, this);
    }
}

