/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalgatesource;

import java.awt.Color;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.sixnode.electricalgatesource.ElectricalGateSourceDescriptor;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ElectricalGateSourceRenderObj {
    private Obj3D.Obj3DPart rot;
    private Obj3D.Obj3DPart main;
    private Obj3D obj;
    private Obj3D.Obj3DPart lever;
    private Obj3D.Obj3DPart led;
    private Obj3D.Obj3DPart halo;
    ElectricalGateSourceDescriptor.ObjType objType;
    float leverTx;
    private float rotAlphaOn;
    private float rotAlphaOff;
    public float speed;

    public ElectricalGateSourceRenderObj(Obj3D obj) {
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            if (obj.getString("type").equals("pot")) {
                this.objType = ElectricalGateSourceDescriptor.ObjType.Pot;
                this.rot = obj.getPart("rot");
                if (this.rot != null) {
                    this.rotAlphaOff = this.rot.getFloat("alphaOff");
                    this.rotAlphaOn = this.rot.getFloat("alphaOn");
                    this.speed = this.rot.getFloat("speed");
                }
            }
            if (obj.getString("type").equals("button")) {
                this.lever = obj.getPart("button");
                this.led = obj.getPart("led");
                this.halo = obj.getPart("halo");
                this.objType = ElectricalGateSourceDescriptor.ObjType.Button;
                if (this.lever != null) {
                    this.speed = this.lever.getFloat("speed");
                    this.leverTx = this.lever.getFloat("tx");
                }
            }
        }
    }

    public void draw(float factor, float distance, TileEntity e) {
        switch (this.objType) {
            case Button: {
                if (this.main != null) {
                    this.main.draw();
                }
                GL11.glTranslatef((float)(this.leverTx * factor), (float)0.0f, (float)0.0f);
                if (this.lever != null) {
                    this.lever.draw();
                }
                UtilsClient.ledOnOffColor(factor > 0.5f);
                UtilsClient.disableLight();
                if (this.led != null) {
                    this.led.draw();
                }
                UtilsClient.enableBlend();
                if (this.halo != null) {
                    if (e == null) {
                        UtilsClient.drawLight(this.halo);
                    } else {
                        Color c = UtilsClient.ledOnOffColorC(factor > 0.5f);
                        UtilsClient.drawHaloNoLightSetup(this.halo, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, e, false);
                    }
                }
                UtilsClient.disableBlend();
                UtilsClient.enableLight();
                break;
            }
            case Pot: {
                if (this.main != null) {
                    this.main.draw();
                }
                if (this.rot == null) break;
                this.rot.draw(factor * (this.rotAlphaOn - this.rotAlphaOff) + this.rotAlphaOff, 1.0f, 0.0f, 0.0f);
            }
        }
    }
}

