/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalmath;

import java.util.Collections;
import java.util.List;
import mods.eln.gui.GuiLabel;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.electricalmath.ElectricalMathElement;
import mods.eln.sixnode.electricalmath.ElectricalMathRender;
import mods.eln.wiki.Data;
import mods.eln.wiki.GuiVerticalExtender;
import mods.eln.wiki.ItemDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalMathDescriptor
extends SixNodeDescriptor
implements ItemDefault.IPlugIn {
    public float[] pinDistance;
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart door;
    Obj3D.Obj3DPart[] led = new Obj3D.Obj3DPart[8];
    float alphaOff;
    static final boolean[] ledDefault = new boolean[]{true, false, true, false, true, true, true, false};

    public ElectricalMathDescriptor(String name, Obj3D obj) {
        super(name, ElectricalMathElement.class, ElectricalMathRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.door = obj.getPart("door");
            if (this.door != null) {
                this.alphaOff = this.door.getFloat("alphaOff");
            }
            for (int idx = 0; idx < 8; ++idx) {
                this.led[idx] = obj.getPart("led" + idx);
            }
            this.pinDistance = Utils.getSixNodePinDistance(this.main);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    void draw(float open, boolean[] ledOn) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.door != null) {
            this.door.draw((1.0f - open) * this.alphaOff, 0.0f, 1.0f, 0.0f);
        }
        for (int idx = 0; idx < 8; ++idx) {
            if (ledOn[idx]) {
                if ((idx & 3) == 0) {
                    GL11.glColor3f((float)0.8f, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glColor3f((float)0.0f, (float)0.8f, (float)0.0f);
                }
                UtilsClient.drawLight(this.led[idx]);
                continue;
            }
            GL11.glColor3f((float)0.3f, (float)0.3f, (float)0.3f);
            this.led[idx].draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glTranslatef((float)-0.3f, (float)-0.1f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.draw(0.7f, ledDefault);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Calculates an output signal from\n3 inputs (A, B, C) using an equation.", new Object[0]).split("\n"));
    }

    @Override
    public int top(int y, GuiVerticalExtender extender, ItemStack stack) {
        extender.add(new GuiLabel(6, y, I18N.tr("Applicable mathematical operators:", new Object[0])));
        extender.add(new GuiLabel(6, y += 9, "  + - * / > < "));
        y += 9;
        extender.add(new GuiLabel(6, y += 9, I18N.tr("Applicable boolean operators:", new Object[0])));
        extender.add(new GuiLabel(6, y += 9, "  & | = ^"));
        y += 9;
        extender.add(new GuiLabel(6, y += 9, I18N.tr("Applicable functions:", new Object[0])));
        extender.add(new GuiLabel(6, y += 9, "  if(condition,then,else)"));
        extender.add(new GuiLabel(6, y += 9, "  min(x,y)"));
        extender.add(new GuiLabel(6, y += 9, "  max(x,y)"));
        extender.add(new GuiLabel(6, y += 9, "  sin(alpha)"));
        extender.add(new GuiLabel(6, y += 9, "  cos(alpha)"));
        extender.add(new GuiLabel(6, y += 9, "  abs(value)"));
        extender.add(new GuiLabel(6, y += 9, "  ramp(periode)"));
        extender.add(new GuiLabel(6, y += 9, "  rs(reset,set)"));
        extender.add(new GuiLabel(6, y += 9, "  integrate(value,resetTrigger)"));
        extender.add(new GuiLabel(6, y += 9, "  integrate(value,minOutput,maxOutput)"));
        extender.add(new GuiLabel(6, y += 9, "  derivate(value)"));
        extender.add(new GuiLabel(6, y += 9, "  batteryCharge(normalizedBatVoltage)"));
        extender.add(new GuiLabel(6, y += 9, "  rc(tao,value)"));
        extender.add(new GuiLabel(6, y += 9, "  pid(target,hit,p,i,d)"));
        extender.add(new GuiLabel(6, y += 9, "  pid(target,hit,p,i,d,minOut,maxOut)"));
        y += 9;
        return y += 9;
    }

    @Override
    public int bottom(int y, GuiVerticalExtender extender, ItemStack stack) {
        return y;
    }
}

