/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalredstoneinput;

import mods.eln.misc.Coordonate;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricalredstoneinput.ElectricalRedstoneInputElement;

public class ElectricalRedstoneInputSlowProcess
implements IProcess {
    ElectricalRedstoneInputElement element;
    double sleepCounter = 0.0;
    static final double sleepDuration = 0.15;
    public int oldSignal = 0;

    public ElectricalRedstoneInputSlowProcess(ElectricalRedstoneInputElement element) {
        this.element = element;
    }

    @Override
    public void process(double time) {
        if (this.sleepCounter == 0.0) {
            Coordonate coord = this.element.sixNode.coordonate;
            int signal = Utils.getRedstoneLevelAround(coord);
            this.element.outputGateProcess.setOutputNormalized((double)signal / 15.0);
            if (signal != this.oldSignal) {
                this.element.needPublish();
            }
            this.sleepCounter = 0.15 + Math.random() * 0.15;
            this.oldSignal = signal;
        } else {
            this.sleepCounter -= time;
            if (this.sleepCounter < 0.0) {
                this.sleepCounter = 0.0;
            }
        }
    }
}

