/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalrelay;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.electricalrelay.ElectricalRelayDescriptor;
import mods.eln.sixnode.electricalrelay.ElectricalRelayGateProcess;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalRelayElement
extends SixNodeElement {
    public ElectricalRelayDescriptor descriptor;
    public NbtElectricalLoad aLoad = new NbtElectricalLoad("aLoad");
    public NbtElectricalLoad bLoad = new NbtElectricalLoad("bLoad");
    public Resistor switchResistor = new Resistor(this.aLoad, this.bLoad);
    public NbtElectricalGateInput gate = new NbtElectricalGateInput("gate");
    public ElectricalRelayGateProcess gateProcess = new ElectricalRelayGateProcess(this, "GP", this.gate);
    VoltageStateWatchDog voltageWatchDogA = new VoltageStateWatchDog();
    VoltageStateWatchDog voltageWatchDogB = new VoltageStateWatchDog();
    boolean switchState = false;
    boolean defaultOutput = false;
    public ElectricalCableDescriptor cableDescriptor = null;
    public static final byte toogleOutputDefaultId = 3;

    public ElectricalRelayElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalRelayDescriptor)descriptor;
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.switchResistor);
        this.electricalProcessList.add(this.gateProcess);
        this.electricalLoadList.add(this.gate);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.slowProcessList.add(this.voltageWatchDogA);
        this.slowProcessList.add(this.voltageWatchDogB);
        WorldExplosion exp = new WorldExplosion(this).cableExplosion();
        this.voltageWatchDogA.set(this.aLoad).setUNominal(this.descriptor.cable.electricalNominalVoltage).set(exp);
        this.voltageWatchDogB.set(this.bLoad).setUNominal(this.descriptor.cable.electricalNominalVoltage).set(exp);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.switchState = nbt.func_74767_n("switchState");
        this.defaultOutput = nbt.func_74767_n("defaultOutput");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("switchState", this.switchState);
        nbt.func_74757_a("defaultOutput", this.defaultOutput);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front.left() == lrdu) {
            return this.aLoad;
        }
        if (this.front.right() == lrdu) {
            return this.bLoad;
        }
        if (this.front == lrdu) {
            return this.gate;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front.left() == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        if (this.front.right() == lrdu) {
            return this.descriptor.cable.getNodeMask();
        }
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("Ua:", this.aLoad.getU()) + Utils.plotVolt("Ub:", this.bLoad.getU()) + Utils.plotAmpere("I:", this.aLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.switchState);
            stream.writeBoolean(this.defaultOutput);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSwitchState(boolean state) {
        if (state == this.switchState) {
            return;
        }
        this.switchState = state;
        this.refreshSwitchResistor();
        this.play(new SoundCommand("random.click").mulVolume(0.1f, 2.0f).smallRange());
        this.needPublish();
    }

    public void refreshSwitchResistor() {
        if (!this.switchState) {
            this.switchResistor.ultraImpedance();
        } else {
            this.descriptor.applyTo(this.switchResistor);
        }
    }

    public boolean getSwitchState() {
        return this.switchState;
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
        this.setSwitchState(this.switchState);
        this.refreshSwitchResistor();
    }

    @Override
    protected void inventoryChanged() {
        this.computeElectricalLoad();
    }

    public void computeElectricalLoad() {
        this.descriptor.applyTo(this.aLoad);
        this.descriptor.applyTo(this.bLoad);
        this.refreshSwitchResistor();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 3: {
                    this.defaultOutput = !this.defaultOutput;
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }
}

