/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalsource;

import java.util.Collections;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.electricalsource.ElectricalSourceElement;
import mods.eln.sixnode.electricalsource.ElectricalSourceRender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalSourceDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    private Obj3D.Obj3DPart main;
    private Obj3D.Obj3DPart led;
    private boolean signalSource = false;

    public ElectricalSourceDescriptor(String name, Obj3D obj, boolean signalSource) {
        super(name, ElectricalSourceElement.class, ElectricalSourceRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.led = obj.getPart("led");
        }
        this.signalSource = signalSource;
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    public boolean isSignalSource() {
        return this.signalSource;
    }

    void draw(boolean ledOn) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.led != null) {
            if (ledOn) {
                UtilsClient.drawLight(this.led);
            } else {
                GL11.glPushMatrix();
                GL11.glColor3f((float)0.1f, (float)0.1f, (float)0.1f);
                this.led.draw();
                GL11.glPopMatrix();
            }
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Provides an ideal voltage source\nwithout energy or power limitation.", new Object[0]).split("\\\n"));
        list.add("");
        list.add(I18N.tr("Internal resistance: %1$\u2126", Eln.instance.lowVoltageCableDescriptor.electricalRs));
        list.add("");
        list.add(I18N.tr("Creative block.", new Object[0]));
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.draw(false);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.8f, (float)0.3f, (float)0.2f);
                GL11.glRotatef((float)150.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.draw(false);
                GL11.glPopMatrix();
                break;
            }
            case INVENTORY: 
            case FIRST_PERSON_MAP: {
                if (this.signalSource) {
                    VoltageLevelColor.SignalVoltage.drawIconBackground(type);
                }
                super.renderItem(type, item, data);
            }
        }
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        if (this.signalSource) {
            return super.getFrontFromPlace(side, player).left();
        }
        return super.getFrontFromPlace(side, player);
    }
}

