/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalsource;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.BrushDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalsource.ElectricalSourceDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalSourceElement
extends SixNodeElement {
    NbtElectricalLoad electricalLoad = new NbtElectricalLoad("electricalLoad");
    VoltageSource voltageSource = new VoltageSource("voltSrc", this.electricalLoad, null);
    public static final int setVoltageId = 1;
    int color = 0;
    int colorCare = 0;

    public ElectricalSourceElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.electricalLoad);
        this.electricalComponentList.add(this.voltageSource);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte b = nbt.func_74771_c("color");
        this.color = b & 0xF;
        this.colorCare = b >> 4 & 1;
        this.voltageSource.setU(nbt.func_74769_h("voltage"));
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("color", (byte)(this.color + (this.colorCare << 4)));
        nbt.func_74780_a("voltage", this.voltageSource.getU());
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        return this.electricalLoad;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (((ElectricalSourceDescriptor)this.sixNodeElementDescriptor).isSignalSource()) {
            return 4 + (this.color << 16) + (this.colorCare << 20);
        }
        return 1 + (this.color << 16) + (this.colorCare << 20);
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.electricalLoad.getU(), this.voltageSource.getI());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.color << 4);
            stream.writeFloat((float)this.voltageSource.getU());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.applySmallRs(this.electricalLoad);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.colorCare ^= 1;
            Utils.addChatMessage(entityPlayer, "Wire color care " + this.colorCare);
            this.sixNode.reconnect();
        } else if (currentItemStack != null) {
            BrushDescriptor brush;
            int brushColor;
            Item item = currentItemStack.func_77973_b();
            GenericItemUsingDamageDescriptor gen = BrushDescriptor.getDescriptor(currentItemStack);
            if (gen != null && gen instanceof BrushDescriptor && (brushColor = (brush = (BrushDescriptor)gen).getColor(currentItemStack)) != this.color && brush.use(currentItemStack, entityPlayer)) {
                this.color = brushColor;
                this.sixNode.reconnect();
            }
        }
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.voltageSource.setU(stream.readFloat());
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }
}

