/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalsource;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import mods.eln.gui.GuiHelper;
import mods.eln.gui.GuiScreenEln;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.electricalsource.ElectricalSourceRender;

public class ElectricalSourceGui
extends GuiScreenEln {
    GuiTextFieldEln voltage;
    ElectricalSourceRender render;

    public ElectricalSourceGui(ElectricalSourceRender render) {
        this.render = render;
    }

    @Override
    protected GuiHelper newHelper() {
        return new GuiHelper(this, 62, 24);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.voltage = this.newGuiTextField(6, 6, 50);
        this.voltage.setText((float)this.render.voltage);
        this.voltage.setObserver(this);
        this.voltage.setComment(new String[]{I18N.tr("Output voltage", new Object[0])});
    }

    @Override
    public void textFieldNewValue(GuiTextFieldEln textField, String value) {
        float newVoltage;
        try {
            newVoltage = NumberFormat.getInstance().parse(this.voltage.func_146179_b()).floatValue();
        }
        catch (ParseException e) {
            return;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.render.preparePacketForServer(stream);
            stream.writeByte(1);
            stream.writeFloat(newVoltage);
            this.render.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

