/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalswitch;

import java.util.Collections;
import java.util.List;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoadInitializer;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sixnode.electricalswitch.ElectricalSwitchElement;
import mods.eln.sixnode.electricalswitch.ElectricalSwitchRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalSwitchDescriptor
extends SixNodeDescriptor {
    public float speed = 1.0f;
    float alphaOn;
    float alphaOff;
    float leverTx;
    ObjType objType;
    boolean signalSwitch;
    double electricalRs;
    ThermalLoadInitializer thermal;
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart lever;
    Obj3D.Obj3DPart led;
    Obj3D.Obj3DPart halo;
    CableRenderDescriptor cableRender;
    double nominalVoltage;
    double nominalPower;
    double maximalVoltage;
    double maximalPower;
    public float[] pinDistance;

    public ElectricalSwitchDescriptor(String name, CableRenderDescriptor cableRender, Obj3D obj, double nominalVoltage, double nominalPower, double rs, double maximalVoltage, double maximalPower, ThermalLoadInitializer thermal, boolean signalSwitch) {
        super(name, ElectricalSwitchElement.class, ElectricalSwitchRender.class, "switch");
        this.nominalVoltage = nominalVoltage;
        this.nominalPower = nominalPower;
        this.maximalPower = maximalPower;
        this.maximalVoltage = maximalVoltage;
        this.cableRender = cableRender;
        this.electricalRs = rs / 2.0;
        this.obj = obj;
        if (obj != null) {
            if (this.main == null) {
                this.main = obj.getPart("case");
            }
            if (this.main == null) {
                this.main = obj.getPart("main");
            }
            if (this.lever == null) {
                this.lever = obj.getPart("lever");
            }
            if (this.lever == null) {
                this.lever = obj.getPart("button");
            }
            this.led = obj.getPart("led");
            this.halo = obj.getPart("halo");
            if (obj.getString("type").equals("lever")) {
                this.objType = ObjType.Lever;
                if (this.lever != null) {
                    this.speed = this.lever.getFloat("speed");
                    this.alphaOff = this.lever.getFloat("alphaOff");
                    this.alphaOn = this.lever.getFloat("alphaOn");
                }
            } else if (obj.getString("type").equals("button")) {
                this.objType = ObjType.Button;
                if (this.lever != null) {
                    this.speed = this.lever.getFloat("speed");
                    this.leverTx = this.lever.getFloat("tx");
                }
            }
        }
        this.thermal = thermal;
        double I = maximalPower / nominalVoltage;
        thermal.setMaximalPower(I * I * this.electricalRs);
        this.signalSwitch = signalSwitch;
        this.pinDistance = Utils.getSixNodePinDistance(this.main);
        this.voltageLevelColor = signalSwitch ? VoltageLevelColor.SignalVoltage : VoltageLevelColor.fromVoltage(nominalVoltage);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    public void applyTo(ElectricalLoad load) {
        load.setRs(this.electricalRs);
    }

    public void applyTo(Resistor resistor, boolean state) {
        if (state) {
            resistor.setR(this.electricalRs);
        } else {
            resistor.highImpedance();
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            this.draw(0.0f, 0.0f, null);
        } else {
            super.renderItem(type, item, data);
        }
    }

    public void draw(float on, float distance, TileEntity e) {
        switch (this.objType) {
            case Button: {
                if (this.main != null) {
                    this.main.draw();
                }
                GL11.glTranslatef((float)(this.leverTx * on), (float)0.0f, (float)0.0f);
                if (this.lever != null) {
                    this.lever.draw();
                }
                if (on < 0.5f) {
                    GL11.glColor3f((float)0.91764706f, (float)0.3137255f, (float)0.0f);
                    UtilsClient.disableLight();
                    if (this.led != null) {
                        this.led.draw();
                    }
                    UtilsClient.enableBlend();
                    if (this.halo != null) {
                        if (e == null) {
                            UtilsClient.drawLight(this.halo);
                        } else {
                            UtilsClient.drawHaloNoLightSetup(this.halo, 0.91764706f, 0.3137255f, 0.0f, e, false);
                        }
                    }
                    UtilsClient.disableBlend();
                    UtilsClient.enableLight();
                    break;
                }
                if (this.led == null) break;
                this.led.draw();
                break;
            }
            case Lever: {
                if (this.main != null) {
                    this.main.draw();
                }
                if (this.lever == null) break;
                this.lever.draw(on * (this.alphaOn - this.alphaOff) + this.alphaOff, 0.0f, 1.0f, 0.0f);
                break;
            }
        }
    }

    public int getNodeMask() {
        if (this.signalSwitch) {
            return 4;
        }
        return 1;
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Can break an electrical circuit\ninterrupting the current.", new Object[0]).split("\n"));
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        if (this.signalSwitch) {
            return super.getFrontFromPlace(side, player);
        }
        return super.getFrontFromPlace(side, player).inverse();
    }

    static enum ObjType {
        Lever,
        Button;

    }
}

