/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalswitch;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalswitch.ElectricalSwitchDescriptor;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalSwitchElement
extends SixNodeElement {
    public ElectricalSwitchDescriptor descriptor;
    public NbtElectricalLoad aLoad = new NbtElectricalLoad("aLoad");
    public NbtElectricalLoad bLoad = new NbtElectricalLoad("bLoad");
    public ResistorSwitch switchResistor = new ResistorSwitch("switchRes", this.aLoad, this.bLoad);
    VoltageStateWatchDog voltageWatchDogA = new VoltageStateWatchDog();
    VoltageStateWatchDog voltageWatchDogB = new VoltageStateWatchDog();
    boolean switchState = false;

    public ElectricalSwitchElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.switchResistor.mustUseUltraImpedance();
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.switchResistor);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.descriptor = (ElectricalSwitchDescriptor)descriptor;
        WorldExplosion exp = new WorldExplosion(this).cableExplosion();
        this.slowProcessList.add(this.voltageWatchDogA);
        this.slowProcessList.add(this.voltageWatchDogB);
        this.voltageWatchDogA.set(this.aLoad).setUNominalMirror(this.descriptor.nominalVoltage).set(exp);
        this.voltageWatchDogB.set(this.bLoad).setUNominalMirror(this.descriptor.nominalVoltage).set(exp);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.switchState = nbt.func_74767_n("switchState");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74757_a("switchState", this.switchState);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.aLoad;
        }
        if (this.front.inverse() == lrdu) {
            return this.bLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.descriptor.getNodeMask();
        }
        if (this.front.inverse() == lrdu) {
            return this.descriptor.getNodeMask();
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("Ua:", this.aLoad.getU()) + Utils.plotVolt("Ub:", this.bLoad.getU()) + Utils.plotAmpere("I:", this.aLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.switchState);
            stream.writeShort((short)(this.aLoad.getU() * 10.0));
            stream.writeShort((short)(this.bLoad.getU() * 10.0));
            stream.writeShort((short)(this.aLoad.getCurrent() * 100.0));
            stream.writeShort(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSwitchState(boolean state) {
        this.switchState = state;
        this.switchResistor.setState(state);
        this.needPublish();
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.aLoad);
        this.descriptor.applyTo(this.bLoad);
        this.switchResistor.setR(this.descriptor.electricalRs);
        this.setSwitchState(this.switchState);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        if (Eln.multiMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        if (Eln.thermoMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        if (Eln.allMeterElement.checkSameItemStack(entityPlayer.func_71045_bC())) {
            return false;
        }
        this.setSwitchState(!this.switchState);
        this.play(new SoundCommand("random.click").mulVolume(0.3f, 0.6f).smallRange());
        return true;
    }
}

