/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaltimeout;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.electricaltimeout.ElectricalTimeoutDescriptor;
import mods.eln.sixnode.electricaltimeout.ElectricalTimeoutProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalTimeoutElement
extends SixNodeElement {
    public ElectricalTimeoutDescriptor descriptor;
    public NbtElectricalGateInput inputGate = new NbtElectricalGateInput("inputGate");
    public NbtElectricalGateOutput outputGate = new NbtElectricalGateOutput("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public ElectricalTimeoutProcess slowProcess = new ElectricalTimeoutProcess(this);
    double timeOutCounter = 0.0;
    double timeOutValue = 2.0;
    public static final byte resetId = 1;
    public static final byte setTimeOutValueId = 2;
    public static final byte setId = 3;

    public ElectricalTimeoutElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.inputGate);
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.thermalProcessList.add(this.slowProcess);
        this.descriptor = (ElectricalTimeoutDescriptor)descriptor;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.timeOutValue = nbt.func_74760_g("timeOutValue");
        this.timeOutCounter = nbt.func_74760_g("timeOutCounter");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74776_a("timeOutValue", (float)this.timeOutValue);
        nbt.func_74776_a("timeOutCounter", (float)this.timeOutCounter);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.inputGate;
        }
        if (this.front.inverse() == lrdu) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        if (this.front.inverse() == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return this.inputGate.plot("Input:") + this.outputGate.plot("Output:");
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)this.timeOutValue);
            stream.writeFloat((float)this.timeOutCounter);
            stream.writeBoolean(this.slowProcess.inputState);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    void set() {
        this.timeOutCounter = this.timeOutValue;
        this.needPublish();
    }

    void reset() {
        this.timeOutCounter = 0.0;
        this.needPublish();
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.reset();
                    break;
                }
                case 3: {
                    this.set();
                    break;
                }
                case 2: {
                    this.timeOutValue = stream.readFloat();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }
}

