/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricaltimeout;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricaltimeout.ElectricalTimeoutDescriptor;
import mods.eln.sixnode.electricaltimeout.ElectricalTimeoutGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalTimeoutRender
extends SixNodeElementRender {
    ElectricalTimeoutDescriptor descriptor;
    long time;
    float timeoutValue = 0.0f;
    float timeoutCounter = 0.0f;
    boolean inputState;

    public ElectricalTimeoutRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalTimeoutDescriptor)descriptor;
        this.time = System.currentTimeMillis();
    }

    @Override
    public void draw() {
        super.draw();
        this.front.glRotateOnX();
        this.descriptor.draw(this.timeoutCounter / this.timeoutValue);
    }

    @Override
    public void refresh(float deltaT) {
        if (!this.inputState) {
            this.timeoutCounter -= deltaT;
            if (this.timeoutCounter < 0.0f) {
                this.timeoutCounter = 0.0f;
            }
        }
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.timeoutValue = stream.readFloat();
            this.timeoutCounter = stream.readFloat();
            this.inputState = stream.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalTimeoutGui(player, this);
    }
}

