/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalvumeter;

import java.awt.Color;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.electricalvumeter.ElectricalVuMeterElement;
import mods.eln.sixnode.electricalvumeter.ElectricalVuMeterRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalVuMeterDescriptor
extends SixNodeDescriptor {
    Obj3D obj;
    ObjType objType;
    Obj3D.Obj3DPart vumeter;
    Obj3D.Obj3DPart pointer;
    Obj3D.Obj3DPart led;
    Obj3D.Obj3DPart halo;
    Obj3D.Obj3DPart main;
    public boolean onOffOnly;
    public float[] pinDistance;

    public ElectricalVuMeterDescriptor(String name, String objName, boolean onOffOnly) {
        super(name, ElectricalVuMeterElement.class, ElectricalVuMeterRender.class);
        this.onOffOnly = onOffOnly;
        this.obj = Eln.obj.getObj(objName);
        if (this.obj != null) {
            if (this.obj.getString("type").toLowerCase().equals("rot")) {
                this.objType = ObjType.Rot;
                this.vumeter = this.obj.getPart("Vumeter");
                this.pointer = this.obj.getPart("Pointer");
                this.pinDistance = Utils.getSixNodePinDistance(this.vumeter);
            }
            if (this.obj.getString("type").equals("LedOnOff")) {
                this.objType = ObjType.LedOnOff;
                this.main = this.obj.getPart("main");
                this.halo = this.obj.getPart("halo");
                this.led = this.obj.getPart("Led");
                this.pinDistance = Utils.getSixNodePinDistance(this.main);
            }
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    void draw(float factor, float distance, TileEntity entity) {
        if ((double)factor < 0.0) {
            factor = 0.0f;
        }
        if ((double)factor > 1.0) {
            factor = 1.0f;
        }
        switch (this.objType) {
            case LedOnOff: {
                this.main.draw();
                boolean s = (double)factor > 0.5;
                Color c = UtilsClient.ledOnOffColorC(s);
                GL11.glColor3f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f));
                UtilsClient.drawLight(this.led);
                if (entity != null) {
                    UtilsClient.drawHalo(this.halo, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, entity, false);
                    break;
                }
                UtilsClient.drawLight(this.halo);
                break;
            }
            case Rot: {
                this.vumeter.draw();
                float alphaOff = this.pointer.getFloat("alphaOff");
                float alphaOn = this.pointer.getFloat("alphaOn");
                this.pointer.draw(factor * (alphaOn - alphaOff) + alphaOff, 1.0f, 0.0f, 0.0f);
                break;
            }
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Displays the value of a signal.", new Object[0]));
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(0.0f, 1.0f, null);
        }
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }

    static enum ObjType {
        Rot,
        LedOnOff;

    }
}

