/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalvumeter;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sixnode.electricalvumeter.ElectricalVuMeterDescriptor;
import mods.eln.sixnode.electricalvumeter.ElectricalVuMeterSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalVuMeterElement
extends SixNodeElement {
    public NbtElectricalGateInput inputGate = new NbtElectricalGateInput("inputGate");
    public ElectricalVuMeterSlowProcess slowProcess = new ElectricalVuMeterSlowProcess(this);
    ElectricalVuMeterDescriptor descriptor;

    public ElectricalVuMeterElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalVuMeterDescriptor)descriptor;
        this.electricalLoadList.add(this.inputGate);
        this.slowProcessList.add(this.slowProcess);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.inputGate;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.inputGate.getU()) + Utils.plotAmpere("I:", this.inputGate.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.front.toInt() << 4);
            stream.writeFloat((float)(this.inputGate.getU() / 50.0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }
}

