/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalvumeter;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalvumeter.ElectricalVuMeterDescriptor;

public class ElectricalVuMeterRender
extends SixNodeElementRender {
    ElectricalVuMeterDescriptor descriptor;
    PhysicalInterpolator interpolator;
    float factor;
    LRDU front;
    boolean boot = true;

    public ElectricalVuMeterRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalVuMeterDescriptor)descriptor;
        this.interpolator = new PhysicalInterpolator(0.4f, 2.0f, 1.5f, 0.2f);
    }

    @Override
    public void draw() {
        super.draw();
        this.drawSignalPin(this.front, this.descriptor.pinDistance);
        if (this.side.isY()) {
            this.front.right().glRotateOnX();
        }
        this.descriptor.draw(this.descriptor.onOffOnly ? this.interpolator.getTarget() : this.interpolator.get(), UtilsClient.distanceFromClientPlayer(this.tileEntity), this.tileEntity);
    }

    @Override
    public void refresh(float deltaT) {
        this.interpolator.step(deltaT);
    }

    @Override
    public boolean cameraDrawOptimisation() {
        return false;
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.front = LRDU.fromInt(b >> 4 & 3);
            if (this.boot) {
                this.interpolator.setPos(stream.readFloat());
            } else {
                this.interpolator.setTarget(stream.readFloat());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.boot) {
            this.boot = false;
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }
}

