/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalvumeter;

import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricalvumeter.ElectricalVuMeterElement;

public class ElectricalVuMeterSlowProcess
implements IProcess {
    ElectricalVuMeterElement element;
    double timeCounter = 0.0;
    static final double refreshPeriode = 0.25;
    boolean lastState;

    public ElectricalVuMeterSlowProcess(ElectricalVuMeterElement element) {
        this.element = element;
        this.lastState = element.inputGate.stateHigh();
    }

    @Override
    public void process(double time) {
        if (this.element.descriptor.onOffOnly) {
            if (this.lastState) {
                if (this.element.inputGate.stateLow()) {
                    this.lastState = false;
                    this.element.needPublish();
                }
            } else if (this.element.inputGate.stateHigh()) {
                this.lastState = true;
                this.element.needPublish();
            }
        } else {
            this.timeCounter += time;
            if (this.timeCounter >= 0.25) {
                this.timeCounter -= 0.25;
                this.element.needPublish();
            }
        }
    }
}

