/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalwatch;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalwatch.ElectricalWatchDescriptor;
import mods.eln.sixnode.electricalwatch.ElectricalWatchGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalWatchRender
extends SixNodeElementRender {
    ElectricalWatchDescriptor descriptor;
    boolean upToDate = false;
    long oldDate = 1379L;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);

    public ElectricalWatchRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ElectricalWatchDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        long time = this.upToDate ? this.tileEntity.func_145831_w().func_72820_D() : this.oldDate;
        time += 6000L;
        this.front.glRotateOnX();
        this.descriptor.draw((float)(time %= 24000L) / 12000.0f, (float)(time % 1000L) / 1000.0f, this.upToDate);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.upToDate = stream.readBoolean();
            this.oldDate = stream.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ElectricalWatchGui(player, this.inventory, this);
    }
}

