/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalweathersensor;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.electricalweathersensor.ElectricalWeatherSensorElement;
import mods.eln.sixnode.electricalweathersensor.ElectricalWeatherSensorRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElectricalWeatherSensorDescriptor
extends SixNodeDescriptor {
    private Obj3D.Obj3DPart main;
    public float[] pinDistance;
    Obj3D obj;

    public ElectricalWeatherSensorDescriptor(String name, Obj3D obj) {
        super(name, ElectricalWeatherSensorElement.class, ElectricalWeatherSensorRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.pinDistance = Utils.getSixNodePinDistance(this.main);
        }
        this.voltageLevelColor = VoltageLevelColor.SignalVoltage;
    }

    void draw() {
        UtilsClient.disableCulling();
        if (this.main != null) {
            this.main.draw();
        }
        UtilsClient.enableCulling();
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addSignal(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Provides an electrical signal\ndepending the actual weather.", new Object[0]).split("\n"));
        list.add(I18N.tr("Clear: %1$V", 0));
        list.add(I18N.tr("Rain: %1$V", 25.0));
        list.add(I18N.tr("Storm: %1$V", 50.0));
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            this.draw();
        }
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return super.getFrontFromPlace(side, player).right();
    }
}

