/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricalwindsensor;

import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.electricalwindsensor.ElectricalWindSensorDescriptor;
import mods.eln.sixnode.electricalwindsensor.ElectricalWindSensorSlowProcess;
import net.minecraft.entity.player.EntityPlayer;

public class ElectricalWindSensorElement
extends SixNodeElement {
    ElectricalWindSensorDescriptor descriptor;
    public NbtElectricalGateOutput outputGate = new NbtElectricalGateOutput("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public ElectricalWindSensorSlowProcess slowProcess = new ElectricalWindSensorSlowProcess(this);
    public NodePeriodicPublishProcess publishProcess = new NodePeriodicPublishProcess(this.sixNode, 5.0, 5.0);

    public ElectricalWindSensorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.slowProcessList.add(this.slowProcess);
        this.slowProcessList.add(this.publishProcess);
        this.descriptor = (ElectricalWindSensorDescriptor)descriptor;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu.left()) {
            return this.outputGate;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.front == lrdu.left()) {
            return 4;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.outputGate.getU()) + Utils.plotAmpere("I:", this.outputGate.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)Utils.getWind(this.sixNode.coordonate.dimention, this.sixNode.coordonate.y));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

