/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricasensor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.electricasensor.ElectricalSensorContainer;
import mods.eln.sixnode.electricasensor.ElectricalSensorDescriptor;
import mods.eln.sixnode.electricasensor.ElectricalSensorProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricalSensorElement
extends SixNodeElement {
    VoltageStateWatchDog voltageWatchDog = new VoltageStateWatchDog();
    public ElectricalSensorDescriptor descriptor;
    public NbtElectricalLoad aLoad;
    public NbtElectricalLoad bLoad;
    public NbtElectricalLoad outputGate = new NbtElectricalLoad("outputGate");
    public NbtElectricalGateOutputProcess outputGateProcess = new NbtElectricalGateOutputProcess("outputGateProcess", this.outputGate);
    public ElectricalSensorProcess slowProcess = new ElectricalSensorProcess(this);
    public Resistor resistor;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    static final byte dirNone = 0;
    static final byte dirAB = 1;
    static final byte dirBA = 2;
    byte dirType = 0;
    static final byte powerType = 0;
    static final byte currantType = 1;
    static final byte voltageType = 2;
    int typeOfSensor = 2;
    float lowValue = 0.0f;
    float highValue = 50.0f;
    public static final byte setTypeOfSensorId = 1;
    public static final byte setValueId = 2;
    public static final byte setDirType = 3;

    public ElectricalSensorElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (ElectricalSensorDescriptor)descriptor;
        this.aLoad = new NbtElectricalLoad("aLoad");
        this.electricalLoadList.add(this.aLoad);
        WorldExplosion exp = new WorldExplosion(this).cableExplosion();
        if (!this.descriptor.voltageOnly) {
            this.bLoad = new NbtElectricalLoad("bLoad");
            this.resistor = new Resistor(this.aLoad, this.bLoad);
            this.electricalLoadList.add(this.bLoad);
            this.electricalComponentList.add(this.resistor);
        }
        this.electricalLoadList.add(this.outputGate);
        this.electricalComponentList.add(this.outputGateProcess);
        this.electricalProcessList.add(this.slowProcess);
        this.slowProcessList.add(this.voltageWatchDog);
        this.voltageWatchDog.set(this.aLoad).set(exp);
    }

    @Override
    public SixNodeElementInventory getInventory() {
        return this.inventory;
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.typeOfSensor = nbt.func_74771_c("typeOfSensor");
        this.lowValue = nbt.func_74760_g("lowValue");
        this.highValue = nbt.func_74760_g("highValue");
        this.dirType = nbt.func_74771_c("dirType");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)(this.front.toInt() << 0));
        nbt.func_74774_a("typeOfSensor", (byte)this.typeOfSensor);
        nbt.func_74776_a("lowValue", this.lowValue);
        nbt.func_74776_a("highValue", this.highValue);
        nbt.func_74774_a("dirType", this.dirType);
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (!this.descriptor.voltageOnly) {
            if (this.front.left() == lrdu) {
                return this.aLoad;
            }
            if (this.front.right() == lrdu) {
                return this.bLoad;
            }
            if (this.front == lrdu) {
                return this.outputGate;
            }
        } else {
            if (this.front.inverse() == lrdu) {
                return this.aLoad;
            }
            if (this.front == lrdu) {
                return this.outputGate;
            }
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        boolean cable;
        boolean bl = cable = this.inventory.func_70301_a(0) != null;
        if (!this.descriptor.voltageOnly) {
            if (this.front.left() == lrdu && cable) {
                return 5;
            }
            if (this.front.right() == lrdu && cable) {
                return 5;
            }
            if (this.front == lrdu) {
                return 4;
            }
        } else {
            if (this.front.inverse() == lrdu && cable) {
                return 5;
            }
            if (this.front == lrdu) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        if (!this.descriptor.voltageOnly) {
            return Utils.plotUIP(this.aLoad.getU(), this.aLoad.getCurrent());
        }
        return Utils.plotVolt("Uin:", this.aLoad.getU()) + Utils.plotVolt("Uout:", this.outputGate.getU());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.typeOfSensor);
            stream.writeFloat(this.lowValue);
            stream.writeFloat(this.highValue);
            stream.writeByte(this.dirType);
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        Eln.instance.signalCableDescriptor.applyTo(this.outputGate);
        this.computeElectricalLoad();
        Eln.applySmallRs(this.aLoad);
        if (this.bLoad != null) {
            Eln.applySmallRs(this.bLoad);
        }
    }

    @Override
    protected void inventoryChanged() {
        this.computeElectricalLoad();
        this.reconnect();
    }

    public void computeElectricalLoad() {
        ItemStack cable = this.inventory.func_70301_a(0);
        ElectricalCableDescriptor cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (cableDescriptor == null) {
            if (this.resistor != null) {
                this.resistor.highImpedance();
            }
            this.voltageWatchDog.setUNominal(1.0E9);
        } else {
            if (this.resistor != null) {
                cableDescriptor.applyTo(this.resistor, 2.0);
            }
            this.voltageWatchDog.setUNominal(cableDescriptor.electricalNominalVoltage);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.typeOfSensor = stream.readByte();
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.lowValue = stream.readFloat();
                    this.highValue = stream.readFloat();
                    if (this.lowValue == this.highValue) {
                        this.highValue = (float)((double)this.highValue + 1.0E-4);
                    }
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.dirType = stream.readByte();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new ElectricalSensorContainer(player, (IInventory)this.inventory, this.descriptor);
    }
}

