/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricasensor;

import java.text.NumberFormat;
import java.text.ParseException;
import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.HelperStdContainer;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.electricasensor.ElectricalSensorContainer;
import mods.eln.sixnode.electricasensor.ElectricalSensorRender;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class ElectricalSensorGui
extends GuiContainerEln {
    GuiButton validate;
    GuiButton voltageType;
    GuiButton currentType;
    GuiButton powerType;
    GuiButton dirType;
    GuiTextFieldEln lowValue;
    GuiTextFieldEln highValue;
    ElectricalSensorRender render;

    public ElectricalSensorGui(EntityPlayer player, IInventory inventory, ElectricalSensorRender render) {
        super(new ElectricalSensorContainer(player, inventory, render.descriptor));
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.render.descriptor.voltageOnly) {
            this.voltageType = this.newGuiButton(8, 8, 50, I18N.tr("Voltage", new Object[0]));
            this.currentType = this.newGuiButton(8, 32, 50, I18N.tr("Current", new Object[0]));
            this.powerType = this.newGuiButton(8, 56, 50, I18N.tr("Power", new Object[0]));
            this.dirType = this.newGuiButton(62, 56, 50, "");
            int x = 0;
            int y = -12;
            this.validate = this.newGuiButton(x + 8 + 50 + 4 + 50 + 4, y + 41 - 9, 50, I18N.tr("Validate", new Object[0]));
            this.lowValue = this.newGuiTextField(x + 8 + 50 + 4, y + 41 + 3, 50);
            this.lowValue.setText(this.render.lowValue);
            this.lowValue.setComment(I18N.tr("Measured value\ncorresponding\nto 0% output", new Object[0]).split("\n"));
            this.highValue = this.newGuiTextField(x + 8 + 50 + 4, y + 41 - 13, 50);
            this.highValue.setText(this.render.highValue);
            this.highValue.setComment(I18N.tr("Measured value\ncorresponding\nto 100% output", new Object[0]).split("\n"));
        } else {
            this.validate = this.newGuiButton(62, 10, 50, I18N.tr("Validate", new Object[0]));
            this.lowValue = this.newGuiTextField(8, 22, 50);
            this.lowValue.setText(this.render.lowValue);
            this.lowValue.setComment(I18N.tr("Measured voltage\ncorresponding\nto 0% output", new Object[0]).split("\n"));
            this.highValue = this.newGuiTextField(8, 6, 50);
            this.highValue.setText(this.render.highValue);
            this.highValue.setComment(I18N.tr("Measured voltage\ncorresponding\nto 100% output", new Object[0]).split("\n"));
        }
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.validate) {
            try {
                float lowVoltage = NumberFormat.getInstance().parse(this.lowValue.func_146179_b()).floatValue();
                float highVoltage = NumberFormat.getInstance().parse(this.highValue.func_146179_b()).floatValue();
                this.render.clientSetFloat(2, lowVoltage, highVoltage);
            }
            catch (ParseException parseException) {}
        } else if (object == this.currentType) {
            this.render.clientSetByte((byte)1, (byte)1);
        } else if (object == this.voltageType) {
            this.render.clientSetByte((byte)1, (byte)2);
        } else if (object == this.powerType) {
            this.render.clientSetByte((byte)1, (byte)0);
        } else if (object == this.dirType) {
            this.render.dirType = (byte)((this.render.dirType + 1) % 3);
            this.render.clientSetByte((byte)3, this.render.dirType);
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        if (!this.render.descriptor.voltageOnly) {
            switch (this.render.dirType) {
                case 0: {
                    this.dirType.field_146126_j = "\u00a72\u25cf\u00a77 <=> \u00a71\u25cf";
                    break;
                }
                case 1: {
                    this.dirType.field_146126_j = "\u00a72\u25cf\u00a77 => \u00a71\u25cf";
                    break;
                }
                case 2: {
                    this.dirType.field_146126_j = "\u00a72\u25cf\u00a77 <= \u00a71\u25cf";
                }
            }
            if (this.render.typeOfSensor == 1) {
                this.powerType.field_146124_l = true;
                this.currentType.field_146124_l = false;
                this.voltageType.field_146124_l = true;
            } else if (this.render.typeOfSensor == 2) {
                this.powerType.field_146124_l = true;
                this.currentType.field_146124_l = true;
                this.voltageType.field_146124_l = false;
            } else if (this.render.typeOfSensor == 0) {
                this.powerType.field_146124_l = false;
                this.currentType.field_146124_l = true;
                this.voltageType.field_146124_l = true;
            }
        }
    }

    @Override
    protected GuiHelperContainer newHelper() {
        if (!this.render.descriptor.voltageOnly) {
            return new HelperStdContainer((GuiScreen)this);
        }
        return new GuiHelperContainer((GuiScreen)this, 176, 121, 8, 39);
    }
}

