/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.electricasensor;

import mods.eln.sim.IProcess;
import mods.eln.sixnode.electricasensor.ElectricalSensorElement;

public class ElectricalSensorProcess
implements IProcess {
    ElectricalSensorElement sensor;

    public ElectricalSensorProcess(ElectricalSensorElement sensor) {
        this.sensor = sensor;
    }

    @Override
    public void process(double time) {
        if (this.sensor.typeOfSensor == 2) {
            this.setOutput(this.sensor.aLoad.getU());
        } else if (this.sensor.typeOfSensor == 1) {
            double output = 0.0;
            switch (this.sensor.dirType) {
                case 0: {
                    output = Math.abs(this.sensor.resistor.getCurrent());
                    break;
                }
                case 1: {
                    output = this.sensor.resistor.getCurrent();
                    break;
                }
                case 2: {
                    output = -this.sensor.resistor.getCurrent();
                }
            }
            this.setOutput(output);
        } else if (this.sensor.typeOfSensor == 0) {
            double output = 0.0;
            switch (this.sensor.dirType) {
                case 0: {
                    output = Math.abs(this.sensor.resistor.getCurrent() * this.sensor.aLoad.getU());
                    break;
                }
                case 1: {
                    output = this.sensor.resistor.getCurrent() * this.sensor.aLoad.getU();
                    break;
                }
                case 2: {
                    output = -this.sensor.resistor.getCurrent() * this.sensor.aLoad.getU();
                }
            }
            this.setOutput(output);
        }
    }

    void setOutput(double physical) {
        double U = (physical - (double)this.sensor.lowValue) / (double)(this.sensor.highValue - this.sensor.lowValue) * 50.0;
        if (U > 50.0) {
            U = 50.0;
        }
        if (U < 0.0) {
            U = 0.0;
        }
        this.sensor.outputGateProcess.setU(U);
    }
}

