/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.energymeter;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.ResistorSwitch;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.energymeter.EnergyMeterContainer;
import mods.eln.sixnode.energymeter.EnergyMeterDescriptor;
import mods.eln.sound.SoundCommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyMeterElement
extends SixNodeElement {
    VoltageStateWatchDog voltageWatchDogA = new VoltageStateWatchDog();
    VoltageStateWatchDog voltageWatchDogB = new VoltageStateWatchDog();
    public SlowProcess slowProcess = new SlowProcess();
    public EnergyMeterDescriptor descriptor;
    public NbtElectricalLoad aLoad = new NbtElectricalLoad("aLoad");
    public NbtElectricalLoad bLoad = new NbtElectricalLoad("bLoad");
    public ResistorSwitch shunt = new ResistorSwitch("shunt", this.aLoad, this.bLoad);
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    public float voltageMax = 50.0f;
    public float voltageMin = 0.0f;
    int energyUnit = 1;
    int timeUnit = 0;
    public ElectricalCableDescriptor cableDescriptor = null;
    public static final byte clientEnergyStackId = 1;
    public static final byte clientModId = 2;
    public static final byte clientPasswordId = 3;
    public static final byte clientToggleStateId = 4;
    public static final byte clientTimeCounterId = 5;
    public static final byte clientEnergyUnitId = 6;
    public static final byte clientTimeUnitId = 7;
    public static final byte serverPowerId = 1;
    String password = "";
    double energyStack = 0.0;
    double timeCounter = 0.0;
    Mod mod = Mod.ModCounter;

    public EnergyMeterElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.shunt.mustUseUltraImpedance();
        this.electricalLoadList.add(this.aLoad);
        this.electricalLoadList.add(this.bLoad);
        this.electricalComponentList.add(this.shunt);
        this.electricalComponentList.add(new Resistor(this.bLoad, null).pullDown());
        this.electricalComponentList.add(new Resistor(this.aLoad, null).pullDown());
        this.slowProcessList.add(this.slowProcess);
        WorldExplosion exp = new WorldExplosion(this).cableExplosion();
        this.slowProcessList.add(this.voltageWatchDogA);
        this.slowProcessList.add(this.voltageWatchDogB);
        this.voltageWatchDogA.set(this.aLoad).set(exp);
        this.voltageWatchDogB.set(this.bLoad).set(exp);
        this.descriptor = (EnergyMeterDescriptor)descriptor;
    }

    @Override
    public SixNodeElementInventory getInventory() {
        return this.inventory;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.front == lrdu) {
            return this.aLoad;
        }
        if (this.front.inverse() == lrdu) {
            return this.bLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (this.front == lrdu) {
            return 5;
        }
        if (this.front.inverse() == lrdu) {
            return 5;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("Ua:", this.aLoad.getU()) + Utils.plotVolt("Ub:", this.bLoad.getU()) + Utils.plotVolt("I:", this.aLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return "";
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeBoolean(this.shunt.getState());
            stream.writeUTF(this.password);
            stream.writeUTF(this.mod.toString());
            stream.writeDouble(this.timeCounter);
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
            stream.writeByte(this.energyUnit);
            stream.writeByte(this.timeUnit);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSwitchState(boolean state) {
        if (state == this.shunt.getState()) {
            return;
        }
        this.shunt.setState(state);
        this.play(new SoundCommand("random.click").mulVolume(0.3f, 0.6f).smallRange());
        this.needPublish();
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
    }

    @Override
    protected void inventoryChanged() {
        this.computeElectricalLoad();
        this.reconnect();
    }

    public void computeElectricalLoad() {
        ItemStack cable = this.inventory.func_70301_a(0);
        this.cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (this.cableDescriptor == null) {
            this.aLoad.highImpedance();
            this.bLoad.highImpedance();
            this.voltageWatchDogA.disable();
            this.voltageWatchDogB.disable();
        } else {
            this.cableDescriptor.applyTo(this.aLoad);
            this.cableDescriptor.applyTo(this.bLoad);
            this.voltageWatchDogA.setUNominalMirror(this.cableDescriptor.electricalNominalVoltage);
            this.voltageWatchDogB.setUNominalMirror(this.cableDescriptor.electricalNominalVoltage);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.energyStack = stream.readDouble();
                    this.slowProcess.publishTimeout = -1.0;
                    break;
                }
                case 5: {
                    this.timeCounter = 0.0;
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.mod = Mod.valueOf(stream.readUTF());
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.password = stream.readUTF();
                    this.needPublish();
                    break;
                }
                case 4: {
                    this.setSwitchState(!this.shunt.getState());
                    break;
                }
                case 6: {
                    ++this.energyUnit;
                    if (this.energyUnit > 3) {
                        this.energyUnit = 0;
                    }
                    this.needPublish();
                    break;
                }
                case 7: {
                    ++this.timeUnit;
                    if (this.timeUnit > 1) {
                        this.timeUnit = 0;
                    }
                    this.needPublish();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new EnergyMeterContainer(player, this.inventory);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        try {
            this.mod = Mod.valueOf(nbt.func_74779_i("mode"));
        }
        catch (Exception e) {
            this.mod = Mod.ModCounter;
        }
        this.energyStack = nbt.func_74769_h("energyStack");
        this.timeCounter = nbt.func_74769_h("timeCounter");
        this.password = nbt.func_74779_i("password");
        this.slowProcess.oldEnergyPublish = this.energyStack;
        this.energyUnit = nbt.func_74771_c("energyUnit");
        this.timeUnit = nbt.func_74771_c("timeUnit");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74778_a("mode", this.mod.toString());
        nbt.func_74780_a("energyStack", this.energyStack);
        nbt.func_74780_a("timeCounter", this.timeCounter);
        nbt.func_74778_a("password", this.password);
        nbt.func_74774_a("energyUnit", (byte)this.energyUnit);
        nbt.func_74774_a("timeUnit", (byte)this.timeUnit);
    }

    class SlowProcess
    implements IProcess {
        public static final double publishTimeoutReset = 1.0;
        public double publishTimeout = Math.random() * 1.0;
        public double oldEnergyPublish;

        SlowProcess() {
        }

        @Override
        public void process(double time) {
            EnergyMeterElement.this.timeCounter += time * 72.0;
            double p = EnergyMeterElement.this.aLoad.getCurrent() * EnergyMeterElement.this.aLoad.getU() * (EnergyMeterElement.this.aLoad.getU() > EnergyMeterElement.this.bLoad.getU() ? 1.0 : -1.0);
            boolean highImp = false;
            switch (EnergyMeterElement.this.mod) {
                case ModCounter: {
                    EnergyMeterElement.this.energyStack += p * time;
                    break;
                }
                case ModPrepay: {
                    EnergyMeterElement.this.energyStack -= p * time;
                    if (!(EnergyMeterElement.this.energyStack < 0.0) || !(p > 0.0)) break;
                    highImp = true;
                }
            }
            if (highImp) {
                EnergyMeterElement.this.shunt.ultraImpedance();
            } else {
                Eln.applySmallRs(EnergyMeterElement.this.shunt);
            }
            this.publishTimeout -= time;
            if (this.publishTimeout < 0.0) {
                this.publishTimeout += 1.0;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
                DataOutputStream packet = new DataOutputStream(bos);
                EnergyMeterElement.this.preparePacketForClient(packet);
                try {
                    packet.writeByte(1);
                    packet.writeDouble(this.oldEnergyPublish);
                    packet.writeDouble((EnergyMeterElement.this.energyStack - this.oldEnergyPublish) / 1.0);
                    EnergyMeterElement.this.sendPacketToAllClient(bos, 10.0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.oldEnergyPublish = EnergyMeterElement.this.energyStack;
            }
        }
    }

    static enum Mod {
        ModCounter,
        ModPrepay;

    }
}

