/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.energymeter;

import java.text.NumberFormat;
import java.text.ParseException;
import mods.eln.gui.GuiButtonEln;
import mods.eln.gui.GuiContainerEln;
import mods.eln.gui.GuiHelperContainer;
import mods.eln.gui.GuiTextFieldEln;
import mods.eln.gui.IGuiObject;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.energymeter.EnergyMeterContainer;
import mods.eln.sixnode.energymeter.EnergyMeterElement;
import mods.eln.sixnode.energymeter.EnergyMeterRender;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class EnergyMeterGui
extends GuiContainerEln {
    GuiButtonEln stateBt;
    GuiButtonEln passwordBt;
    GuiButtonEln modBt;
    GuiButtonEln setEnergyBt;
    GuiButtonEln resetTimeBt;
    GuiButtonEln energyUnitBt;
    GuiButtonEln timeUnitBt;
    GuiTextFieldEln passwordFeild;
    GuiTextFieldEln energyFeild;
    EnergyMeterRender render;
    boolean isLogged;

    public EnergyMeterGui(EntityPlayer player, IInventory inventory, EnergyMeterRender render) {
        super(new EnergyMeterContainer(player, inventory));
        this.render = render;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = 6;
        int y = 6;
        this.isLogged = this.render.password.equals("");
        this.passwordFeild = this.newGuiTextField(x, y + 4, 70);
        this.passwordBt = this.newGuiButton(x += 74, y, 106, "");
        this.passwordFeild.setComment(0, I18N.tr("Enter password", new Object[0]));
        x = 6;
        x = 6;
        this.stateBt = this.newGuiButton(x, y += 28, 70, "");
        this.modBt = this.newGuiButton(x += 74, y, 106, "");
        x = 6;
        this.energyFeild = this.newGuiTextField(x, (y += 22) + 4, 70);
        this.setEnergyBt = this.newGuiButton(x += 74, y, 106, I18N.tr("Set energy counter", new Object[0]));
        this.energyFeild.setComment(0, I18N.tr("Enter new energy", new Object[0]));
        this.energyFeild.setComment(1, I18N.tr("value in kJ", new Object[0]));
        this.energyFeild.func_146180_a("0");
        x = 6;
        this.energyUnitBt = this.newGuiButton(x, y += 22, 34, "");
        this.timeUnitBt = this.newGuiButton(x += 36, y, 34, "");
        this.resetTimeBt = this.newGuiButton(x += 38, y, 106, I18N.tr("Reset time counter", new Object[0]));
        y += 22;
        x = 6;
        if (this.render.descriptor.timeNumberWheel.length == 0) {
            this.energyUnitBt.field_146124_l = false;
            this.timeUnitBt.field_146124_l = false;
        }
    }

    @Override
    public void guiObjectEvent(IGuiObject object) {
        super.guiObjectEvent(object);
        if (object == this.stateBt) {
            this.render.clientSend(4);
        }
        if (object == this.passwordBt) {
            if (this.isLogged) {
                this.render.clientSetString((byte)3, this.passwordFeild.func_146179_b());
            } else if (this.passwordFeild.func_146179_b().equals(this.render.password)) {
                this.isLogged = true;
            }
        }
        if (object == this.modBt) {
            switch (this.render.mod) {
                case ModCounter: {
                    this.render.clientSetString((byte)2, EnergyMeterElement.Mod.ModPrepay.name());
                    break;
                }
                case ModPrepay: {
                    this.render.clientSetString((byte)2, EnergyMeterElement.Mod.ModCounter.name());
                }
            }
        }
        if (object == this.setEnergyBt) {
            double newVoltage;
            try {
                newVoltage = NumberFormat.getInstance().parse(this.energyFeild.func_146179_b()).doubleValue();
            }
            catch (ParseException e) {
                return;
            }
            this.render.clientSetDouble((byte)1, newVoltage * 1000.0);
        }
        if (object == this.resetTimeBt) {
            this.render.clientSend(5);
        }
        if (object == this.energyUnitBt) {
            this.render.clientSend(6);
        }
        if (object == this.timeUnitBt) {
            this.render.clientSend(7);
        }
    }

    @Override
    protected void preDraw(float f, int x, int y) {
        super.preDraw(f, x, y);
        this.stateBt.field_146126_j = !this.render.switchState ? I18N.tr("is off", new Object[0]) : I18N.tr("is on", new Object[0]);
        this.passwordBt.field_146126_j = this.isLogged ? I18N.tr("Change password", new Object[0]) : I18N.tr("Try password", new Object[0]);
        switch (this.render.mod) {
            case ModCounter: {
                this.modBt.field_146126_j = I18N.tr("Counter Mode", new Object[0]);
                this.modBt.clearComment();
                int lineNumber = 0;
                for (String line : I18N.tr("Counts the energy conducted from\n\u00a74red\u00a7f to \u00a71blue\u00a7f.", new Object[0]).split("\n")) {
                    this.modBt.setComment(lineNumber++, line);
                }
                break;
            }
            case ModPrepay: {
                this.modBt.field_146126_j = I18N.tr("Prepay Mode", new Object[0]);
                this.modBt.clearComment();
                int lineNumber = 0;
                for (String line : I18N.tr("Counts the energy conducted from\n\u00a74red\u00a7f to \u00a71blue\u00a7f.", new Object[0]).split("\n")) {
                    this.modBt.setComment(lineNumber++, line);
                }
                this.modBt.setComment(lineNumber++, "");
                for (String line : I18N.tr("You can set an initial\namount of available energy.\nWhen the counter arrives at 0\nthe contact will be opened.", new Object[0]).split("\n")) {
                    this.modBt.setComment(lineNumber++, line);
                }
                break;
            }
        }
        if (this.energyUnitBt != null) {
            switch (this.render.energyUnit) {
                case 0: {
                    this.energyUnitBt.field_146126_j = "J";
                    break;
                }
                case 1: {
                    this.energyUnitBt.field_146126_j = "KJ";
                    break;
                }
                case 2: {
                    this.energyUnitBt.field_146126_j = "MJ";
                    break;
                }
                case 3: {
                    this.energyUnitBt.field_146126_j = "GJ";
                    break;
                }
                default: {
                    this.energyUnitBt.field_146126_j = "??";
                }
            }
        }
        if (this.timeUnitBt != null) {
            switch (this.render.timeUnit) {
                case 0: {
                    this.timeUnitBt.field_146126_j = "H";
                    break;
                }
                case 1: {
                    this.timeUnitBt.field_146126_j = "D";
                    break;
                }
                default: {
                    this.timeUnitBt.field_146126_j = "??";
                }
            }
        }
        this.modBt.field_146124_l = this.isLogged;
        this.stateBt.field_146124_l = this.isLogged;
        this.resetTimeBt.field_146124_l = this.isLogged;
        this.setEnergyBt.field_146124_l = this.isLogged;
        this.energyUnitBt.field_146124_l = this.isLogged && this.render.descriptor.timeNumberWheel.length != 0;
        this.timeUnitBt.field_146124_l = this.isLogged && this.render.descriptor.timeNumberWheel.length != 0;
    }

    @Override
    protected void postDraw(float f, int x, int y) {
        super.postDraw(f, x, y);
        this.helper.drawRect(6, 29, this.helper.xSize - 6, 30, -12566464);
        y = 101;
        this.helper.drawRect(6, y, this.helper.xSize - 6, y + 1, -12566464);
        this.helper.drawString(14, y += 3, -16777216, I18N.tr("Energy counter: %1$J", (int)this.render.energyStack));
        this.helper.drawString(14, y += 10, -16777216, I18N.tr("Time counter:", (int)this.render.timerCouter));
    }

    @Override
    protected GuiHelperContainer newHelper() {
        return new GuiHelperContainer((GuiScreen)this, 192, 208, 16, 126);
    }

    static enum SelectedType {
        none,
        min,
        max;

    }
}

