/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.groundcable;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.groundcable.GroundCableDescriptor;
import mods.eln.sixnode.groundcable.GroundCableGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GroundCableRender
extends SixNodeElementRender {
    GroundCableDescriptor descriptor;
    int color = 0;
    CableRenderDescriptor cableRender;
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);

    public GroundCableRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (GroundCableDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        if (this.side.isY()) {
            this.front.glRotateOnX();
        }
        this.descriptor.draw();
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            Byte b = stream.readByte();
            this.color = b >> 4 & 0xF;
            ItemStack cableStack = Utils.unserialiseItemStack(stream);
            ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack, ElectricalCableDescriptor.class);
            this.cableRender = desc == null ? Eln.instance.lowVoltageCableDescriptor.render : desc.render;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return this.cableRender;
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new GroundCableGui(player, this.inventory, this);
    }
}

