/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.hub;

import java.util.Collections;
import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.hub.HubElement;
import mods.eln.sixnode.hub.HubRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class HubDescriptor
extends SixNodeDescriptor {
    Obj3D obj;
    Obj3D.Obj3DPart main;
    Obj3D.Obj3DPart[] connection = new Obj3D.Obj3DPart[6];

    public HubDescriptor(String name, Obj3D obj) {
        super(name, HubElement.class, HubRender.class);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            for (int idx = 0; idx < 6; ++idx) {
                this.connection[idx] = obj.getPart("con" + idx);
            }
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    void draw(boolean[] connectionGrid) {
        if (this.main != null) {
            this.main.draw();
        }
        for (int idx = 0; idx < 6; ++idx) {
            if (connectionGrid[idx]) {
                GL11.glColor3f((float)0.15686275f, (float)0.15686275f, (float)0.15686275f);
            } else {
                GL11.glColor3f((float)0.5882353f, (float)0.5882353f, (float)0.5882353f);
            }
            if (this.connection[idx] == null) continue;
            this.connection[idx].draw();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addWiring(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Allows crossing cables\non one single block.", new Object[0]).split("\n"));
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return LRDU.Up;
    }
}

