/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.hub;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.hub.HubDescriptor;
import mods.eln.sixnode.hub.HubGui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class HubRender
extends SixNodeElementRender {
    HubDescriptor descriptor;
    int color = 0;
    CableRenderDescriptor[] cableRender = new CableRenderDescriptor[4];
    boolean[] connectionGrid = new boolean[6];
    SixNodeElementInventory inventory = new SixNodeElementInventory(4, 64, this);

    public HubRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (HubDescriptor)descriptor;
    }

    @Override
    public void draw() {
        super.draw();
        this.descriptor.draw(this.connectionGrid);
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            int idx;
            for (idx = 0; idx < 4; ++idx) {
                ItemStack cableStack = Utils.unserialiseItemStack(stream);
                ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack, ElectricalCableDescriptor.class);
                this.cableRender[idx] = desc == null ? null : desc.render;
            }
            for (idx = 0; idx < 6; ++idx) {
                this.connectionGrid[idx] = stream.readBoolean();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return this.cableRender[lrdu.toInt()];
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new HubGui(player, this.inventory, this);
    }
}

