/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketElement;
import mods.eln.sixnode.lampsocket.LampSocketObjRender;
import mods.eln.sixnode.lampsocket.LampSocketRender;
import mods.eln.sixnode.lampsocket.LampSocketType;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LampSocketDescriptor
extends SixNodeDescriptor {
    public LampSocketType socketType;
    LampSocketObjRender render;
    boolean useIconEnable = false;
    public boolean cameraOpt = true;
    public int range;
    public String modelName;
    float alphaZMin;
    float alphaZMax;
    float alphaZBoot;
    public boolean cableFront = true;
    public boolean cableLeft = true;
    public boolean cableRight = true;
    public boolean cableBack = true;
    public float initialRotateDeg = 0.0f;
    public boolean rotateOnlyBy180Deg = false;
    public boolean paintable = false;

    public LampSocketDescriptor(String name, LampSocketObjRender render, LampSocketType socketType, boolean paintable, int range, float alphaZMin, float alphaZMax, float alphaZBoot) {
        super(name, LampSocketElement.class, LampSocketRender.class);
        this.socketType = socketType;
        this.paintable = paintable;
        this.range = range;
        this.alphaZMin = alphaZMin;
        this.alphaZMax = alphaZMax;
        this.alphaZBoot = alphaZBoot;
        this.render = render;
    }

    public void setInitialOrientation(float rotateDeg) {
        this.initialRotateDeg = rotateDeg;
    }

    public void setUserRotationLibertyDegrees(boolean only180) {
        this.rotateOnlyBy180Deg = only180;
    }

    public void useIcon(boolean enable) {
        this.useIconEnable = enable;
    }

    boolean noCameraOpt() {
        return this.cameraOpt;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addLight(this.newItemStack());
    }

    @Override
    public boolean use2DIcon() {
        return this.useIconEnable;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return !this.useIconEnable;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return !this.useIconEnable;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.useIconEnable) {
            super.renderItem(type, item, data);
        } else {
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            this.render.draw(this, type, 0.0);
        }
    }

    @Override
    public boolean hasVolume() {
        return this.hasGhostGroup();
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        if (this.range != 0 || this.alphaZMin != this.alphaZMax) {
            if (this.range != 0) {
                list.add(I18N.tr("Spot range: %1$ blocks", this.range));
            }
            if (this.alphaZMin != this.alphaZMax) {
                list.add(I18N.tr("Angle: %1$\u00b0 to %2$\u00b0", (int)this.alphaZMin, (int)this.alphaZMax));
            }
        }
    }
}

