/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.Eln;
import mods.eln.generic.GenericItemBlockUsingDamageDescriptor;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.BrushDescriptor;
import mods.eln.item.LampDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.MonsterPopFreeProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketContainer;
import mods.eln.sixnode.lampsocket.LampSocketDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LampSocketElement
extends SixNodeElement {
    LampSocketDescriptor socketDescriptor = null;
    public MonsterPopFreeProcess monsterPopFreeProcess;
    public NbtElectricalLoad positiveLoad;
    public LampSocketProcess lampProcess;
    public Resistor lampResistor;
    boolean poweredByLampSupply;
    boolean grounded;
    SixNodeElementInventory inventory;
    LampDescriptor lampDescriptor;
    public String channel;
    public static String lastSocketName = "Default channel";
    static final int setGroundedId = 1;
    static final int setAlphaZId = 2;
    static final int tooglePowerSupplyType = 3;
    static final int setChannel = 4;
    boolean isConnectedToLampSupply;
    public int paintColor;

    public LampSocketElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.monsterPopFreeProcess = new MonsterPopFreeProcess(this.sixNode.coordonate, Eln.instance.killMonstersAroundLampsRange);
        this.positiveLoad = new NbtElectricalLoad("positiveLoad");
        this.lampProcess = new LampSocketProcess(this);
        this.lampResistor = new Resistor(this.positiveLoad, null);
        this.poweredByLampSupply = true;
        this.grounded = true;
        this.inventory = new SixNodeElementInventory(2, 64, this);
        this.lampDescriptor = null;
        this.channel = lastSocketName;
        this.isConnectedToLampSupply = false;
        this.paintColor = 15;
        this.socketDescriptor = (LampSocketDescriptor)descriptor;
        this.lampProcess.alphaZ = this.socketDescriptor.alphaZBoot;
        this.slowProcessList.add(this.lampProcess);
        this.slowProcessList.add(this.monsterPopFreeProcess);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        byte value = nbt.func_74771_c("front");
        this.front = LRDU.fromInt(value >> 0 & 3);
        this.grounded = (value & 4) != 0;
        this.setPoweredByLampSupply(nbt.func_74767_n("poweredByLampSupply"));
        this.channel = nbt.func_74779_i("channel");
        byte b = nbt.func_74771_c("color");
        this.paintColor = this.socketDescriptor.paintable ? b & 0xF : 15;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74774_a("front", (byte)((this.front.toInt() << 0) + (this.grounded ? 4 : 0)));
        nbt.func_74757_a("poweredByLampSupply", this.poweredByLampSupply);
        nbt.func_74778_a("channel", this.channel);
        nbt.func_74774_a("color", (byte)this.paintColor);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.grounded = stream.readByte() != 0;
                    this.computeElectricalLoad();
                    this.reconnect();
                    break;
                }
                case 2: {
                    this.lampProcess.alphaZ = stream.readFloat();
                    this.needPublish();
                    break;
                }
                case 3: {
                    this.setPoweredByLampSupply(!this.poweredByLampSupply);
                    this.reconnect();
                    break;
                }
                case 4: {
                    lastSocketName = this.channel = stream.readUTF();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setPoweredByLampSupply(boolean b) {
        this.poweredByLampSupply = b;
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        this.electricalLoadList.remove(this.positiveLoad);
        this.electricalComponentList.remove(this.lampResistor);
        this.positiveLoad.state = 0.0;
    }

    @Override
    public void connectJob() {
        if (!this.poweredByLampSupply) {
            this.electricalLoadList.add(this.positiveLoad);
            this.electricalComponentList.add(this.lampResistor);
        }
        super.connectJob();
    }

    @Override
    protected void inventoryChanged() {
        this.computeElectricalLoad();
        this.reconnect();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new LampSocketContainer(player, (IInventory)this.inventory, this.socketDescriptor);
    }

    public static boolean canBePlacedOnSide(Direction side, int type) {
        return true;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.inventory.func_70301_a(1) == null) {
            return null;
        }
        if (this.poweredByLampSupply) {
            return null;
        }
        if (this.grounded) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.inventory.func_70301_a(1) == null) {
            return 0;
        }
        if (this.poweredByLampSupply) {
            return 0;
        }
        if (this.grounded) {
            return 1;
        }
        if (this.front == lrdu) {
            return 1;
        }
        if (this.front == lrdu.inverse()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U:", this.positiveLoad.getU()) + Utils.plotAmpere("I:", this.lampResistor.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeByte(this.grounded ? 64 : 0);
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
            stream.writeFloat((float)this.lampProcess.alphaZ);
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(1));
            stream.writeBoolean(this.poweredByLampSupply);
            stream.writeUTF(this.channel);
            stream.writeBoolean(this.isConnectedToLampSupply);
            stream.writeByte(this.lampProcess.light);
            stream.writeByte(this.paintColor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
        this.computeElectricalLoad();
    }

    public void computeElectricalLoad() {
        ItemStack lamp = this.inventory.func_70301_a(0);
        ItemStack cable = this.inventory.func_70301_a(1);
        ElectricalCableDescriptor cableDescriptor = (ElectricalCableDescriptor)Eln.sixNodeItem.getDescriptor(cable);
        if (cableDescriptor == null) {
            this.positiveLoad.highImpedance();
        } else {
            cableDescriptor.applyTo(this.positiveLoad);
        }
        this.lampDescriptor = (LampDescriptor)Utils.getItemObject(lamp);
        if (this.lampDescriptor == null) {
            this.lampResistor.setR(Double.POSITIVE_INFINITY);
        } else {
            this.lampDescriptor.applyTo(this.lampResistor);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            if (this.socketDescriptor.rotateOnlyBy180Deg) {
                this.front = this.front.getNextClockwise();
            }
            this.reconnect();
            return true;
        }
        ItemStack currentItemStack = entityPlayer.func_71045_bC();
        if (currentItemStack != null) {
            GenericItemUsingDamageDescriptor itemDescriptor = GenericItemUsingDamageDescriptor.getDescriptor(currentItemStack);
            if (itemDescriptor != null) {
                if (itemDescriptor instanceof BrushDescriptor) {
                    BrushDescriptor brush = (BrushDescriptor)itemDescriptor;
                    int brushColor = brush.getColor(currentItemStack);
                    if (brushColor != this.paintColor && brush.use(currentItemStack, entityPlayer)) {
                        this.paintColor = brushColor;
                        this.needPublish();
                    }
                    return true;
                }
                if (itemDescriptor instanceof LampDescriptor && this.inventory.func_70301_a(0) == null) {
                    --currentItemStack.field_77994_a;
                    this.inventory.func_70299_a(0, itemDescriptor.newItemStack());
                    this.needPublish();
                    return true;
                }
            } else {
                GenericItemBlockUsingDamageDescriptor blockDescriptor = GenericItemBlockUsingDamageDescriptor.getDescriptor(currentItemStack);
                if (blockDescriptor != null && blockDescriptor instanceof ElectricalCableDescriptor && this.inventory.func_70301_a(1) == null) {
                    --currentItemStack.field_77994_a;
                    this.inventory.func_70299_a(1, blockDescriptor.newItemStack());
                    this.reconnect();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getLightValue() {
        return this.lampProcess.getBlockLight();
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        super.destroy(entityPlayer);
        this.lampProcess.destructor();
    }

    void setIsConnectedToLampSupply(boolean value) {
        if (this.isConnectedToLampSupply != value) {
            this.isConnectedToLampSupply = value;
            this.needPublish();
        }
    }
}

