/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamage;
import mods.eln.item.LampDescriptor;
import mods.eln.misc.Coordonate;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.server.SaveConfig;
import mods.eln.sim.IProcess;
import mods.eln.sixnode.lampsocket.LampSocketElement;
import mods.eln.sixnode.lampsocket.LightBlockEntity;
import mods.eln.sixnode.lampsupply.LampSupplyElement;
import mods.eln.sound.SoundCommand;
import mods.eln.sound.SoundLooper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class LampSocketProcess
implements IProcess,
INBTTReady {
    double time = 0.0;
    double deltaTBase;
    double deltaT = this.deltaTBase = 0.2;
    public double invulerabilityTimeLeft = 2.0;
    boolean overPoweredInvulerabilityArmed = true;
    LampSocketElement lamp;
    int light = 0;
    double alphaZ = 0.0;
    double stableProb = 0.0;
    ItemStack lampStackLast = null;
    boolean boot = true;
    double[] vp = new double[3];
    SoundLooper looper;
    private LampSupplyElement oldLampSupply;
    double updateLifeTimeout = 0.0;
    double updateLifeTimeoutMax = 5.0;
    Coordonate lbCoord;

    public LampSocketProcess(LampSocketElement l) {
        this.lamp = l;
        this.lbCoord = new Coordonate(l.sixNode.coordonate);
        this.looper = new SoundLooper(l){
            double bzTimeout;
            SoundCommand bzzzz;
            {
                this.bzTimeout = 0.0;
                this.bzzzz = new SoundCommand("eln:NEON_LFNOISE", 0.5).mulVolume(0.12).smallRange();
            }

            @Override
            public SoundCommand mustStart() {
                ItemStack lampStack = LampSocketProcess.this.lamp.inventory.func_70301_a(0);
                LampDescriptor lampDescriptor = null;
                if (lampStack != null) {
                    lampDescriptor = (LampDescriptor)((GenericItemUsingDamage)lampStack.func_77973_b()).getDescriptor(lampStack);
                }
                if (lampDescriptor == null || lampDescriptor.type != LampDescriptor.Type.eco || this.bzTimeout == 0.0 || this.bzTimeout < 2.0) {
                    // empty if block
                }
                return null;
            }

            @Override
            public void process(double time) {
                this.bzTimeout = LampSocketProcess.this.light <= 5 ? 0.0 : (this.bzTimeout += time);
                super.process(time);
            }
        };
    }

    @Override
    public void process(double time) {
        this.looper.process(time);
        ItemStack lampStack = this.lamp.inventory.func_70301_a(0);
        if (!this.lamp.poweredByLampSupply || this.lamp.inventory.func_70301_a(1) == null) {
            this.lamp.setIsConnectedToLampSupply(false);
            this.oldLampSupply = null;
        } else {
            Coordonate myCoord = this.lamp.sixNode.coordonate;
            LampSupplyElement.PowerSupplyChannelHandle best = null;
            float bestDistance = 10000.0f;
            List list = LampSupplyElement.channelMap.get(this.lamp.channel);
            if (list != null) {
                for (LampSupplyElement.PowerSupplyChannelHandle s : list) {
                    float distance = (float)s.element.sixNode.coordonate.trueDistanceTo(myCoord);
                    if (!(distance < bestDistance) || !(distance <= (float)s.element.getRange())) continue;
                    bestDistance = distance;
                    best = s;
                }
            }
            if (best != null && best.element.getChannelState(best.id)) {
                if (lampStack != null) {
                    LampDescriptor lampDescriptor = (LampDescriptor)((GenericItemUsingDamage)lampStack.func_77973_b()).getDescriptor(lampStack);
                    best.element.addToRp(lampDescriptor.getR());
                }
                this.lamp.positiveLoad.state = best.element.powerLoad.state;
                this.oldLampSupply = best.element;
            } else {
                this.lamp.positiveLoad.state = 0.0;
                this.oldLampSupply = null;
            }
            this.lamp.setIsConnectedToLampSupply(best != null);
        }
        if (lampStack != null) {
            double randTarget;
            LampDescriptor lampDescriptor = (LampDescriptor)((GenericItemUsingDamage)lampStack.func_77973_b()).getDescriptor(lampStack);
            if (this.lamp.getCoordonate().getBlockExist() && lampDescriptor.vegetableGrowRate != 0.0 && (randTarget = 1.0 / lampDescriptor.vegetableGrowRate * time * (1.0 * (double)this.light / lampDescriptor.nominalLight / 15.0)) > Math.random()) {
                Block b;
                boolean exit = false;
                Vec3 vv = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
                Vec3 vp = Vec3.func_72443_a((double)((double)this.myCoord().x + 0.5), (double)((double)this.myCoord().y + 0.5), (double)((double)this.myCoord().z + 0.5));
                vv.func_72446_c((float)(this.alphaZ * Math.PI / 180.0));
                vv.func_72442_b((float)((Math.random() - 0.5) * 2.0 * Math.PI / 4.0));
                vv.func_72446_c((float)((Math.random() - 0.5) * 2.0 * Math.PI / 4.0));
                this.lamp.front.rotateOnXnLeft(vv);
                this.lamp.side.rotateFromXN(vv);
                Coordonate c = new Coordonate(this.myCoord());
                for (int idx = 0; idx < this.lamp.socketDescriptor.range + this.light; ++idx) {
                    vp.field_72450_a += vv.field_72450_a;
                    vp.field_72448_b += vv.field_72448_b;
                    vp.field_72449_c += vv.field_72449_c;
                    c.setPosition(vp);
                    Block b2 = c.getBlock();
                    if (!c.getBlockExist()) {
                        exit = true;
                        break;
                    }
                    if (!this.isOpaque(c)) continue;
                    vp.field_72450_a -= vv.field_72450_a;
                    vp.field_72448_b -= vv.field_72448_b;
                    vp.field_72449_c -= vv.field_72449_c;
                    c.setPosition(vp);
                    b2 = c.getBlock();
                    break;
                }
                if (!exit && (b = c.getBlock()) != Blocks.field_150350_a) {
                    b.func_149674_a(c.world(), c.x, c.y, c.z, c.world().field_73012_v);
                }
            }
        }
        this.time += time;
        if (this.time < this.deltaT) {
            return;
        }
        this.time -= this.deltaT;
        this.lamp.computeElectricalLoad();
        int oldLight = this.light;
        int newLight = 0;
        if (!(this.boot || lampStack == this.lampStackLast && lampStack != null)) {
            this.stableProb = 0.0;
        }
        if (lampStack != null) {
            double overFactor;
            LampDescriptor lampDescriptor = (LampDescriptor)((GenericItemUsingDamage)lampStack.func_77973_b()).getDescriptor(lampStack);
            if (this.stableProb < 0.0) {
                this.stableProb = 0.0;
            }
            double lightDouble = 0.0;
            switch (lampDescriptor.type) {
                case Incandescent: 
                case LED: {
                    lightDouble = lampDescriptor.nominalLight * (Math.abs(this.lamp.lampResistor.getU()) - lampDescriptor.minimalU) / (lampDescriptor.nominalU - lampDescriptor.minimalU);
                    lightDouble *= 16.0;
                    break;
                }
                case eco: {
                    double U = Math.abs(this.lamp.lampResistor.getU());
                    if (U < lampDescriptor.minimalU) {
                        this.stableProb = 0.0;
                        lightDouble = 0.0;
                        break;
                    }
                    double powerFactor = U / lampDescriptor.nominalU;
                    this.stableProb += U / lampDescriptor.stableU * this.deltaT / lampDescriptor.stableTime * lampDescriptor.stableUNormalised;
                    if (this.stableProb > U / lampDescriptor.stableU) {
                        this.stableProb = U / lampDescriptor.stableU;
                    }
                    if (Math.random() > this.stableProb) {
                        lightDouble = 0.0;
                        break;
                    }
                    lightDouble = lampDescriptor.nominalLight * powerFactor;
                    lightDouble *= 16.0;
                    break;
                }
            }
            newLight = lightDouble - (double)oldLight > 1.0 ? (int)lightDouble : (lightDouble - (double)oldLight < -0.3 ? (int)lightDouble : oldLight);
            if (newLight < 0) {
                newLight = 0;
            }
            if (newLight > 14) {
                newLight = 14;
            }
            if ((overFactor = this.lamp.lampResistor.getP() / lampDescriptor.nominalP) < 0.0) {
                overFactor = 0.0;
            }
            if (overFactor < 1.3) {
                this.overPoweredInvulerabilityArmed = true;
            }
            if (overFactor > 1.5 && this.overPoweredInvulerabilityArmed) {
                this.invulerabilityTimeLeft = 2.0;
                this.overPoweredInvulerabilityArmed = false;
            }
            if (this.invulerabilityTimeLeft != 0.0 && overFactor > 1.5) {
                overFactor = 1.5;
            }
            this.updateLifeTimeout += this.deltaT;
            if (this.updateLifeTimeout > this.updateLifeTimeoutMax && (lampDescriptor.type != LampDescriptor.Type.LED || !Eln.ledLampInfiniteLife)) {
                this.updateLifeTimeout -= this.updateLifeTimeoutMax;
                double lifeLost = overFactor * this.updateLifeTimeoutMax / lampDescriptor.nominalLife;
                lifeLost = Utils.voltageMargeFactorSub(lifeLost);
                if (overFactor >= 1.21) {
                    lifeLost *= overFactor;
                }
                double life = lampDescriptor.getLifeInTag(lampStack) - lifeLost;
                if (SaveConfig.instance.electricalLampAging) {
                    lampDescriptor.setLifeInTag(lampStack, life);
                }
                if (life < 0.0 || overFactor > 3.0) {
                    this.lamp.inventory.func_70299_a(0, null);
                    this.light = 0;
                }
            }
            this.boot = false;
        }
        if (this.invulerabilityTimeLeft != 0.0) {
            this.invulerabilityTimeLeft -= this.deltaT;
            if (this.invulerabilityTimeLeft < 0.0) {
                this.invulerabilityTimeLeft = 0.0;
            }
        }
        this.deltaT = this.deltaTBase + this.deltaTBase * (-0.1 + 0.2 * Math.random());
        this.lampStackLast = lampStack;
        this.placeSpot(newLight);
    }

    public void rotateAroundZ(Vec3 v, float par1) {
        float f1 = MathHelper.func_76134_b((float)par1);
        float f2 = MathHelper.func_76126_a((float)par1);
        double d0 = v.field_72450_a * (double)f1 + v.field_72448_b * (double)f2;
        double d1 = v.field_72448_b * (double)f1 - v.field_72450_a * (double)f2;
        double d2 = v.field_72449_c;
        v.field_72450_a = d0;
        v.field_72448_b = d1;
        v.field_72449_c = d2;
    }

    void placeSpot(int newLight) {
        boolean exit = false;
        if (!this.lbCoord.getBlockExist()) {
            return;
        }
        Vec3 vv = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
        Vec3 vp = Utils.getVec05(this.myCoord());
        this.rotateAroundZ(vv, (float)(this.alphaZ * Math.PI / 180.0));
        this.lamp.front.rotateOnXnLeft(vv);
        this.lamp.side.rotateFromXN(vv);
        Coordonate newCoord = new Coordonate(this.myCoord());
        for (int idx = 0; idx < this.lamp.socketDescriptor.range; ++idx) {
            vp.field_72450_a += vv.field_72450_a;
            vp.field_72448_b += vv.field_72448_b;
            vp.field_72449_c += vv.field_72449_c;
            newCoord.setPosition(vp);
            if (!newCoord.getBlockExist()) {
                exit = true;
                break;
            }
            if (!this.isOpaque(newCoord)) continue;
            vp.field_72450_a -= vv.field_72450_a;
            vp.field_72448_b -= vv.field_72448_b;
            vp.field_72449_c -= vv.field_72449_c;
            newCoord.setPosition(vp);
            break;
        }
        if (!exit) {
            Block block;
            int count = 0;
            while (!newCoord.equals(this.myCoord()) && ((block = newCoord.getBlock()) != Blocks.field_150350_a && block != Eln.lightBlock || ++count != 2)) {
                vp.field_72450_a -= vv.field_72450_a;
                vp.field_72448_b -= vv.field_72448_b;
                vp.field_72449_c -= vv.field_72449_c;
                newCoord.setPosition(vp);
            }
        }
        if (!exit) {
            this.setLightAt(newCoord, newLight);
        }
    }

    public boolean isOpaque(Coordonate coord) {
        boolean isNotOpaque;
        Block block = coord.getBlock();
        boolean bl = isNotOpaque = block == Blocks.field_150350_a || !block.func_149662_c();
        if (block == Blocks.field_150458_ak) {
            isNotOpaque = false;
        }
        return !isNotOpaque;
    }

    public void publish() {
        Utils.print("Light published");
    }

    public void setLightAt(Coordonate coord, int value) {
        Coordonate oldLbCoord = this.lbCoord;
        this.lbCoord = new Coordonate(coord);
        int oldLight = this.light;
        boolean same = coord.equals(oldLbCoord);
        this.light = value;
        if (!same && oldLbCoord.equals(this.myCoord())) {
            this.lamp.sixNode.recalculateLightValue();
        }
        if (this.lbCoord.equals(this.myCoord())) {
            if (this.light != oldLight || !same) {
                this.lamp.sixNode.recalculateLightValue();
            }
        } else {
            LightBlockEntity.addLight(this.lbCoord, this.light, 5);
        }
        if (this.light != oldLight) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
            DataOutputStream packet = new DataOutputStream(bos);
            this.lamp.preparePacketForClient(packet);
            try {
                packet.writeByte(this.light);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.lamp.sendPacketToAllClient(bos);
        }
    }

    Coordonate myCoord() {
        return this.lamp.sixNode.coordonate;
    }

    public void destructor() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.stableProb = nbt.func_74769_h(str + "LSPstableProb");
        this.lbCoord.readFromNBT(nbt, str + "lbCoordInst");
        this.alphaZ = nbt.func_74760_g(str + "alphaZ");
        this.light = nbt.func_74762_e(str + "light");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74780_a(str + "LSPstableProb", this.stableProb);
        this.lbCoord.writeToNBT(nbt, str + "lbCoordInst");
        nbt.func_74776_a(str + "alphaZ", (float)this.alphaZ);
        nbt.func_74768_a(str + "light", this.light);
    }

    public int getBlockLight() {
        if (this.lbCoord.equals(this.myCoord())) {
            return this.light;
        }
        return 0;
    }
}

