/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsocket;

import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.sixnode.lampsocket.LampSocketDescriptor;
import mods.eln.sixnode.lampsocket.LampSocketObjRender;
import mods.eln.sixnode.lampsocket.LampSocketRender;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LampSocketStandardObjRender
implements LampSocketObjRender {
    private Obj3D obj;
    private Obj3D.Obj3DPart socket;
    private Obj3D.Obj3DPart socket_unlightable;
    private Obj3D.Obj3DPart socket_lightable;
    private Obj3D.Obj3DPart lampOn;
    private Obj3D.Obj3DPart lampOff;
    private Obj3D.Obj3DPart lightAlphaPlane;
    private Obj3D.Obj3DPart lightAlphaPlaneNoDepth;
    ResourceLocation tOn;
    ResourceLocation tOff;
    private boolean onOffModel;

    public LampSocketStandardObjRender(Obj3D obj, boolean onOffModel) {
        this.obj = obj;
        this.onOffModel = onOffModel;
        if (obj != null) {
            this.socket = obj.getPart("socket");
            this.lampOn = obj.getPart("lampOn");
            this.lampOff = obj.getPart("lampOff");
            this.socket_unlightable = obj.getPart("socket_unlightable");
            this.socket_lightable = obj.getPart("socket_lightable");
            this.lightAlphaPlane = obj.getPart("lightAlpha");
            this.lightAlphaPlaneNoDepth = obj.getPart("lightAlphaNoDepth");
            this.tOff = obj.getModelResourceLocation(obj.getString("tOff"));
            this.tOn = obj.getModelResourceLocation(obj.getString("tOn"));
        }
    }

    @Override
    public void draw(LampSocketDescriptor descriptor, IItemRenderer.ItemRenderType type, double distanceToPlayer) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            if (descriptor.hasGhostGroup()) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glTranslatef((float)-1.5f, (float)0.0f, (float)0.0f);
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON && descriptor.hasGhostGroup()) {
            GL11.glScalef((float)0.3f, (float)0.3f, (float)0.3f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-1.0f);
        }
        this.draw(LRDU.Up, 0.0f, (byte)0, true, 15, distanceToPlayer);
    }

    @Override
    public void draw(LampSocketRender render, double distanceToPlayer) {
        int color = 15;
        if (render.descriptor.paintable) {
            color = render.paintColor;
        }
        this.draw(render.front, render.alphaZ, render.light, render.lampDescriptor != null, color, distanceToPlayer);
    }

    public void draw(LRDU front, float alphaZ, byte light, boolean hasBulb, int color, double distanceToPlayer) {
        float coeff;
        front.glRotateOnX();
        UtilsClient.disableCulling();
        Utils.setGlColorFromLamp(color);
        if (!this.onOffModel) {
            if (this.socket != null) {
                this.socket.draw();
            }
        } else {
            if (light > 8) {
                UtilsClient.bindTexture(this.tOn);
            } else {
                UtilsClient.bindTexture(this.tOff);
            }
            if (this.socket_unlightable != null) {
                this.socket_unlightable.drawNoBind();
            }
            if (light > 8) {
                UtilsClient.disableLight();
                float l = (float)light / 14.0f;
                if (this.socket_lightable != null) {
                    this.socket_lightable.drawNoBind();
                }
            }
            if (hasBulb) {
                if (light > 8) {
                    if (this.lampOn != null) {
                        this.lampOn.draw();
                    }
                } else if (this.lampOff != null) {
                    this.lampOff.draw();
                }
            }
            if (this.socket != null) {
                this.socket.drawNoBind();
            }
            if (light > 8) {
                UtilsClient.enableLight();
            }
        }
        UtilsClient.enableBlend();
        UtilsClient.disableLight();
        if (this.lightAlphaPlaneNoDepth != null && (coeff = 2.0f - (float)distanceToPlayer) > 0.0f) {
            UtilsClient.enableCulling();
            UtilsClient.disableDepthTest();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)light * 0.06667f * coeff));
            this.lightAlphaPlaneNoDepth.draw();
            UtilsClient.enableDepthTest();
            UtilsClient.disableCulling();
        }
        if (this.lightAlphaPlane != null) {
            GL11.glColor4f((float)1.0f, (float)0.98f, (float)0.92f, (float)((float)light * 0.06667f));
            this.lightAlphaPlane.draw();
        }
        UtilsClient.enableLight();
        UtilsClient.disableBlend();
        UtilsClient.enableCulling();
    }
}

