/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsupply;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.UtilsClient;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.lampsupply.LampSupplyElement;
import mods.eln.sixnode.lampsupply.LampSupplyRender;
import mods.eln.wiki.Data;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class LampSupplyDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    Obj3D.Obj3DPart base;
    private Obj3D.Obj3DPart window;
    private float windowOpenAngle;
    public boolean isWireless = this.isWireless;
    public int range;
    public int channelCount = 3;

    public LampSupplyDescriptor(String name, Obj3D obj, int range) {
        super(name, LampSupplyElement.class, LampSupplyRender.class);
        this.range = range;
        this.obj = obj;
        if (obj != null) {
            this.base = obj.getPart("base");
            this.window = obj.getPart("window");
        }
        if (this.window != null) {
            this.windowOpenAngle = this.window.getFloat("windowOpenAngle");
        }
    }

    @Override
    public boolean use2DIcon() {
        return false;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addLight(this.newItemStack(1));
    }

    public void draw(float openFactor) {
        if (this.base != null) {
            this.base.draw();
        }
        UtilsClient.disableCulling();
        UtilsClient.enableBlend();
        this.obj.bindTexture("Glass.png");
        float rotYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z / 360.0f;
        float rotPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A / 180.0f;
        float pos = ((float)Minecraft.func_71410_x().field_71439_g.field_70165_t + (float)Minecraft.func_71410_x().field_71439_g.field_70161_v) / 64.0f;
        if (this.window != null) {
            this.window.draw((1.0f - openFactor) * this.windowOpenAngle, 0.0f, 0.0f, 1.0f, rotYaw + pos + openFactor * 0.5f, rotPitch * 0.65f);
        }
        UtilsClient.disableBlend();
        UtilsClient.enableCulling();
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)1.3f, (float)1.3f, (float)1.3f);
            GL11.glTranslatef((float)-0.45f, (float)0.0f, (float)0.0f);
        }
        this.draw(1.0f);
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Supplies all lamps on the channel.", new Object[0]));
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return super.getFrontFromPlace(side, player).inverse();
    }
}

