/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.lampsupply;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.sixnode.lampsupply.LampSupplyContainer;
import mods.eln.sixnode.lampsupply.LampSupplyDescriptor;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.WirelessUtils;
import mods.eln.sixnode.wirelesssignal.aggregator.BiggerAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.IWirelessSignalAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.SmallerAggregator;
import mods.eln.sixnode.wirelesssignal.aggregator.ToogleAggregator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LampSupplyElement
extends SixNodeElement {
    public static final HashMap<String, ArrayList<PowerSupplyChannelHandle>> channelMap = new HashMap();
    public LampSupplyDescriptor descriptor;
    public NbtElectricalLoad powerLoad = new NbtElectricalLoad("powerLoad");
    public Resistor loadResistor;
    public IProcess lampSupplySlowProcess = new LampSupplySlowProcess();
    SixNodeElementInventory inventory = new SixNodeElementInventory(1, 64, this);
    public ArrayList<Entry> entries = new ArrayList();
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog();
    public static final byte setPowerName = 1;
    public static final byte setWirelessName = 2;
    public static final byte setSelectedAggregator = 3;
    double RpStack = 0.0;
    boolean[] channelStates;
    IWirelessSignalAggregator[][] aggregators;

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new LampSupplyContainer(player, this.inventory);
    }

    public LampSupplyElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        this.descriptor = (LampSupplyDescriptor)descriptor;
        this.loadResistor = new Resistor(this.powerLoad, null);
        this.electricalComponentList.add(this.loadResistor);
        this.loadResistor.highImpedance();
        this.electricalLoadList.add(this.powerLoad);
        this.slowProcessList.add(this.lampSupplySlowProcess);
        this.slowProcessList.add(this.voltageWatchdog);
        this.voltageWatchdog.set(this.powerLoad).set(new WorldExplosion(this).cableExplosion());
        this.channelStates = new boolean[this.descriptor.channelCount];
        this.aggregators = new IWirelessSignalAggregator[this.descriptor.channelCount][3];
        for (int idx = 0; idx < this.descriptor.channelCount; ++idx) {
            this.channelStates[idx] = false;
            this.entries.add(new Entry("", "", 2));
            this.aggregators[idx][0] = new BiggerAggregator();
            this.aggregators[idx][1] = new SmallerAggregator();
            this.aggregators[idx][2] = new ToogleAggregator();
        }
    }

    static void channelRegister(LampSupplyElement tx, int id, String channel) {
        if (channel.equals("")) {
            return;
        }
        ArrayList<PowerSupplyChannelHandle> list = channelMap.get(channel);
        if (list == null) {
            list = new ArrayList();
            channelMap.put(channel, list);
        }
        list.add(new PowerSupplyChannelHandle(tx, id));
    }

    static void channelRemove(LampSupplyElement tx, int id, String channel) {
        if (channel.equals("")) {
            return;
        }
        List list = channelMap.get(channel);
        if (list == null) {
            return;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            PowerSupplyChannelHandle e = (PowerSupplyChannelHandle)i.next();
            if (e.element != tx || e.id != id) continue;
            i.remove();
        }
        if (list.isEmpty()) {
            channelMap.remove(channel);
        }
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return null;
        }
        if (this.front == lrdu) {
            return this.powerLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return null;
        }
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (this.inventory.func_70301_a(0) == null) {
            return 0;
        }
        if (this.front == lrdu) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotUIP(this.powerLoad.getU(), this.powerLoad.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        this.setupFromInventory();
    }

    @Override
    protected void inventoryChanged() {
        super.inventoryChanged();
        this.sixNode.disconnect();
        this.setupFromInventory();
        this.sixNode.connect();
        this.needPublish();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            this.front = this.front.getNextClockwise();
            this.sixNode.reconnect();
            this.sixNode.setNeedPublish(true);
            return true;
        }
        return false;
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        super.destroy(entityPlayer);
        this.unregister();
    }

    @Override
    public void unload() {
        super.unload();
        this.unregister();
    }

    void unregister() {
        int idx = 0;
        for (Entry e : this.entries) {
            LampSupplyElement.channelRemove(this, idx++, e.powerChannel);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        int idx = 0;
        for (Entry e : this.entries) {
            nbt.func_74778_a("entry_p" + idx, e.powerChannel);
            nbt.func_74778_a("entry_w" + idx, e.wirelessChannel);
            nbt.func_74757_a("channelStates" + idx, this.channelStates[idx]);
            nbt.func_74768_a("selectedAggregator" + idx, e.aggregator);
            ((ToogleAggregator)this.aggregators[idx][2]).writeToNBT(nbt, "toogleAggregator" + idx);
            ++idx;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int idx = 0;
        for (Entry e : this.entries) {
            LampSupplyElement.channelRemove(this, idx++, e.powerChannel);
        }
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("channel")) {
            this.entries.get((int)0).powerChannel = nbt.func_74779_i("channel");
        } else {
            idx = 0;
            while (nbt.func_74764_b("entry_p" + idx)) {
                this.entries.set(idx, new Entry(nbt.func_74779_i("entry_p" + idx), nbt.func_74779_i("entry_w" + idx), nbt.func_74762_e("selectedAggregator" + idx)));
                this.channelStates[idx] = nbt.func_74767_n("channelStates" + idx);
                ((ToogleAggregator)this.aggregators[idx][2]).readFromNBT(nbt, "toogleAggregator" + idx);
                ++idx;
            }
        }
        idx = 0;
        for (Entry e : this.entries) {
            LampSupplyElement.channelRegister(this, idx++, e.powerChannel);
        }
    }

    void setupFromInventory() {
        ItemStack cableStack = this.inventory.func_70301_a(0);
        if (cableStack != null) {
            ElectricalCableDescriptor desc = (ElectricalCableDescriptor)ElectricalCableDescriptor.getDescriptor(cableStack);
            desc.applyTo(this.powerLoad);
            this.voltageWatchdog.setUNominal(desc.electricalNominalVoltage);
        } else {
            this.voltageWatchdog.setUNominal(10000.0);
            this.powerLoad.highImpedance();
        }
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            switch (stream.readByte()) {
                case 1: {
                    byte id = stream.readByte();
                    String newName = stream.readUTF();
                    LampSupplyElement.channelRemove(this, id, this.entries.get((int)id).powerChannel);
                    this.entries.get((int)id).powerChannel = newName;
                    this.needPublish();
                    LampSupplyElement.channelRegister(this, id, newName);
                    break;
                }
                case 2: {
                    byte id = stream.readByte();
                    String newName = stream.readUTF();
                    LampSupplyElement.channelRemove(this, id, this.entries.get((int)id).wirelessChannel);
                    this.entries.get((int)id).wirelessChannel = newName;
                    this.needPublish();
                    LampSupplyElement.channelRegister(this, id, newName);
                    break;
                }
                case 3: {
                    this.entries.get((int)stream.readByte()).aggregator = stream.readByte();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            for (Entry e : this.entries) {
                stream.writeUTF(e.powerChannel);
                stream.writeUTF(e.wirelessChannel);
                stream.writeChar(e.aggregator);
            }
            Utils.serialiseItemStack(stream, this.inventory.func_70301_a(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addToRp(double r) {
        this.RpStack += 1.0 / r;
    }

    public boolean getChannelState(int channel) {
        return this.channelStates[channel];
    }

    public int getRange() {
        return this.getRange(this.descriptor, this.inventory);
    }

    private int getRange(LampSupplyDescriptor desc, SixNodeElementInventory inventory2) {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack == null) {
            return desc.range;
        }
        return desc.range + stack.field_77994_a;
    }

    class LampSupplySlowProcess
    implements IProcess {
        double sleepTimer = 0.0;
        HashMap<String, HashSet<IWirelessSignalTx>> txSet = new HashMap();
        HashMap<IWirelessSignalTx, Double> txStrength = new HashMap();

        LampSupplySlowProcess() {
        }

        @Override
        public void process(double time) {
            LampSupplyElement.this.loadResistor.setR(1.0 / LampSupplyElement.this.RpStack);
            LampSupplyElement.this.RpStack = 0.0;
            this.sleepTimer -= time;
            if (this.sleepTimer < 0.0) {
                this.sleepTimer += Utils.rand(1.2, 2.0);
                WirelessUtils.WirelessSignalSpot spot = WirelessUtils.buildSpot(LampSupplyElement.this.getCoordonate(), null, 0);
                WirelessUtils.getTx(spot, this.txSet, this.txStrength);
            }
            for (int idx = 0; idx < LampSupplyElement.this.descriptor.channelCount; ++idx) {
                HashSet<IWirelessSignalTx> txs;
                Entry e = LampSupplyElement.this.entries.get(idx);
                LampSupplyElement.this.channelStates[idx] = e.wirelessChannel.equals("") ? true : (e.wirelessChannel.toLowerCase().equals("true") ? true : (e.wirelessChannel.toLowerCase().equals("false") ? false : ((txs = this.txSet.get(e.wirelessChannel)) == null ? false : LampSupplyElement.this.aggregators[idx][e.aggregator].aggregate(txs) >= 0.5)));
            }
        }
    }

    static class Entry {
        public String powerChannel;
        public String wirelessChannel;
        public int aggregator;

        Entry(String powerChannel, String wirelessChannel, int aggregator) {
            this.powerChannel = powerChannel;
            this.wirelessChannel = wirelessChannel;
            this.aggregator = aggregator;
        }
    }

    public static class PowerSupplyChannelHandle {
        public LampSupplyElement element;
        public int id;

        PowerSupplyChannelHandle(LampSupplyElement element, int id) {
            this.element = element;
            this.id = id;
        }
    }
}

