/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.logicgate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.i18n.I18N;
import mods.eln.sixnode.logicgate.LogicFunction;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0013\u001a\u00020\u00042\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u001c\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lmods/eln/sixnode/logicgate/Oscillator;", "Lmods/eln/sixnode/logicgate/LogicFunction;", "()V", "hasState", "", "getHasState", "()Z", "infos", "", "kotlin.jvm.PlatformType", "getInfos", "()Ljava/lang/String;", "inputCount", "", "getInputCount", "()I", "ramp", "", "state", "process", "inputs", "", "([Ljava/lang/Double;)Z", "readFromNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "str", "writeToNBT", "ElectricalAge-release_main"})
public final class Oscillator
extends LogicFunction {
    private final boolean hasState = true;
    private final int inputCount = 1;
    private final String infos = I18N.tr("Outputs a rectangular signal which's frequency\ndepends to the input voltage. The higher the\ninput voltage - the higher the frequency.", new Object[0]);
    private double ramp;
    private boolean state;

    @Override
    public boolean getHasState() {
        return this.hasState;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public String getInfos() {
        return this.infos;
    }

    @Override
    public boolean process(@NotNull Double[] inputs) {
        Intrinsics.checkParameterIsNotNull(inputs, "inputs");
        Double d = inputs[0];
        this.ramp += Math.pow(50.0, d != null ? d : 0.0) / (double)50;
        if (this.ramp >= 1.0) {
            this.ramp = 0.0;
            this.state = !this.state;
        }
        return this.state;
    }

    @Override
    public void readFromNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
        NBTTagCompound nBTTagCompound = nbt;
        this.ramp = nBTTagCompound != null ? nBTTagCompound.func_74769_h(Intrinsics.stringPlus(str, "ramp")) : 0.0;
        NBTTagCompound nBTTagCompound2 = nbt;
        this.state = nBTTagCompound2 != null ? nBTTagCompound2.func_74767_n(Intrinsics.stringPlus(str, "state")) : false;
    }

    @Override
    public void writeToNBT(@Nullable NBTTagCompound nbt, @Nullable String str) {
        block1: {
            NBTTagCompound nBTTagCompound = nbt;
            if (nBTTagCompound != null) {
                nBTTagCompound.func_74780_a(Intrinsics.stringPlus(str, "ramp"), this.ramp);
            }
            NBTTagCompound nBTTagCompound2 = nbt;
            if (nBTTagCompound2 == null) break block1;
            nBTTagCompound2.func_74757_a(Intrinsics.stringPlus(str, "state"), this.state);
        }
    }
}

