/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalGateInputOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.modbusrtu.IModbusSlave;
import mods.eln.sixnode.modbusrtu.IModbusSlot;
import mods.eln.sixnode.modbusrtu.IllegalAddressException;
import mods.eln.sixnode.modbusrtu.ModbusNullSlot;
import mods.eln.sixnode.modbusrtu.ModbusRtuDescriptor;
import mods.eln.sixnode.modbusrtu.ServerWirelessRxStatus;
import mods.eln.sixnode.modbusrtu.ServerWirelessTxStatus;
import mods.eln.sixnode.modbusrtu.WirelessRxStatus;
import mods.eln.sixnode.modbusrtu.WirelessTxStatus;
import mods.eln.sixnode.modbusrtu.modbusAnalogIoSlot;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.WirelessUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class ModbusRtuElement
extends SixNodeElement
implements IModbusSlave {
    public NbtElectricalGateInputOutput[] ioGate = new NbtElectricalGateInputOutput[4];
    public NbtElectricalGateOutputProcess[] ioGateProcess = new NbtElectricalGateOutputProcess[4];
    HashMap<Integer, ServerWirelessTxStatus> wirelessTxStatusList = new HashMap();
    HashMap<Integer, ServerWirelessRxStatus> wirelessRxStatusList = new HashMap();
    ModbusRtuDescriptor descriptor;
    static final int ioStartOffset = 16;
    static final int ioRange = 8;
    int station = -1;
    String name = "";
    HashMap<String, HashSet<IWirelessSignalTx>> txSet = new HashMap();
    HashMap<IWirelessSignalTx, Double> txStrength = new HashMap();
    static final byte setStation = 1;
    static final byte setName = 2;
    static final byte serverTxAdd = 3;
    static final byte serverRxAdd = 4;
    static final byte serverTxConfig = 5;
    static final byte serverRxConfig = 6;
    static final byte serverTxDelete = 7;
    static final byte serverRxDelete = 8;
    static final byte serverAllSyncronise = 9;
    static final byte clientAllSyncronise = 1;
    static final byte clientTx1Syncronise = 2;
    static final byte clientRx1Syncronise = 3;
    static final byte clientTxDelete = 4;
    static final byte clientRxDelete = 5;
    static final byte clientRx1Connected = 6;
    static final byte ClientModbusActivityEvent = 7;
    static final byte ClientModbusErrorEvent = 8;
    boolean addedOnServer = false;
    ArrayList<IModbusSlot> mapping = new ArrayList();
    ModbusNullSlot nullSlot = new ModbusNullSlot();

    public ModbusRtuElement(SixNode sixNode, Direction side, SixNodeDescriptor descriptor) {
        super(sixNode, side, descriptor);
        for (int idx = 0; idx < 4; ++idx) {
            this.ioGate[idx] = new NbtElectricalGateInputOutput("ioGate" + idx);
            this.ioGateProcess[idx] = new NbtElectricalGateOutputProcess("ioGateProcess" + idx, this.ioGate[idx]);
            this.electricalLoadList.add(this.ioGate[idx]);
            this.electricalComponentList.add(this.ioGateProcess[idx]);
            this.ioGateProcess[idx].setHighImpedance(true);
            this.mapping.add(new modbusAnalogIoSlot(16 + idx * 8, 8, this.ioGate[idx], this.ioGateProcess[idx]));
        }
        this.slowProcessList.add(new ModbusRtuSlowProcess());
        this.descriptor = (ModbusRtuDescriptor)descriptor;
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        return this.ioGate[lrdu.toInt()];
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        return 4;
    }

    @Override
    public String multiMeterString() {
        return null;
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        this.addToServer();
    }

    @Override
    public void destroy(EntityPlayerMP entityPlayer) {
        super.destroy(entityPlayer);
        this.unregister();
    }

    @Override
    public void unload() {
        super.unload();
        this.unregister();
    }

    void unregister() {
        this.removeFromServer();
        for (Integer key : this.wirelessTxStatusList.keySet()) {
            ServerWirelessTxStatus status = this.wirelessTxStatusList.get(key);
            status.delete();
            this.wirelessTxStatusList.remove(key);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(entityPlayer)) {
            if (side.isY()) {
                this.front = this.front.getNextClockwise();
                this.sixNode.reconnect();
                this.sixNode.setNeedPublish(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeInt(this.station);
            stream.writeUTF(this.name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void sendTx1Syncronise(WirelessTxStatus tx) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(2);
            tx.writeTo(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    void sendRx1Syncronise(WirelessRxStatus rx) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(3);
            rx.writeTo(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    void sendRx1Connected(WirelessRxStatus rx) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(6);
            packet.writeInt(rx.uuid);
            packet.writeBoolean(rx.connected);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    void onActivity() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(7);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    void onError() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputStream packet = new DataOutputStream(bos);
        this.preparePacketForClient(packet);
        try {
            packet.writeByte(8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sendPacketToAllClient(bos);
    }

    @Override
    public void networkUnserialize(DataInputStream stream, EntityPlayerMP player) {
        super.networkUnserialize(stream, player);
        try {
            switch (stream.readByte()) {
                case 1: {
                    this.setStation(stream.readInt());
                    break;
                }
                case 2: {
                    this.setName(stream.readUTF());
                    break;
                }
                case 3: {
                    boolean idx = false;
                    String name = stream.readUTF();
                    int uuid = 0;
                    for (ServerWirelessTxStatus tx : this.wirelessTxStatusList.values()) {
                        uuid = Math.max(uuid, tx.uuid);
                    }
                    ServerWirelessTxStatus tx = new ServerWirelessTxStatus(name, -1, 0.0, this.sixNode.coordonate, ++uuid, this);
                    this.wirelessTxStatusList.put(uuid, tx);
                    this.sendTx1Syncronise(tx);
                    break;
                }
                case 4: {
                    boolean idx = false;
                    String name = stream.readUTF();
                    int uuid = 0;
                    for (ServerWirelessRxStatus rx : this.wirelessRxStatusList.values()) {
                        uuid = Math.max(uuid, rx.uuid);
                    }
                    ServerWirelessRxStatus rx = new ServerWirelessRxStatus(name, -1, false, ++uuid, this);
                    this.wirelessRxStatusList.put(uuid, rx);
                    this.sendRx1Syncronise(rx);
                    break;
                }
                case 5: {
                    int uuid = stream.readInt();
                    String name = stream.readUTF();
                    int id = stream.readInt();
                    WirelessTxStatus tx = this.wirelessTxStatusList.get(uuid);
                    if (tx != null) {
                        tx.setName(name);
                        tx.setId(id);
                        this.sendTx1Syncronise(tx);
                    }
                    break;
                }
                case 6: {
                    int uuid = stream.readInt();
                    String name = stream.readUTF();
                    int id = stream.readInt();
                    WirelessRxStatus rx = this.wirelessRxStatusList.get(uuid);
                    if (rx != null) {
                        rx.setName(name);
                        rx.setId(id);
                        this.sendRx1Syncronise(rx);
                    }
                    break;
                }
                case 7: {
                    int uuid = stream.readInt();
                    ServerWirelessTxStatus tx = this.wirelessTxStatusList.get(uuid);
                    if (tx != null) {
                        tx.delete();
                        this.wirelessTxStatusList.remove(tx.uuid);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
                        DataOutputStream packet = new DataOutputStream(bos);
                        this.preparePacketForClient(packet);
                        packet.writeByte(4);
                        packet.writeInt(uuid);
                        this.sendPacketToAllClient(bos);
                    }
                    break;
                }
                case 8: {
                    int uuid = stream.readInt();
                    ServerWirelessRxStatus rx = this.wirelessRxStatusList.get(uuid);
                    if (rx == null) break;
                    rx.delete();
                    this.wirelessRxStatusList.remove(uuid);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
                    DataOutputStream packet = new DataOutputStream(bos);
                    this.preparePacketForClient(packet);
                    packet.writeByte(5);
                    packet.writeInt(uuid);
                    this.sendPacketToAllClient(bos);
                    break;
                }
                case 9: {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
                    DataOutputStream packet = new DataOutputStream(bos);
                    this.preparePacketForClient(packet);
                    packet.writeByte(1);
                    packet.writeInt(this.wirelessTxStatusList.size());
                    for (ServerWirelessTxStatus serverWirelessTxStatus : this.wirelessTxStatusList.values()) {
                        serverWirelessTxStatus.writeTo(packet);
                    }
                    packet.writeInt(this.wirelessRxStatusList.size());
                    for (WirelessRxStatus wirelessRxStatus : this.wirelessRxStatusList.values()) {
                        wirelessRxStatus.writeTo(packet);
                    }
                    this.sendPacketToClient(bos, player);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setName(String name) {
        this.name = name;
        this.needPublish();
    }

    private void setStation(int port) {
        this.removeFromServer();
        this.station = port;
        this.addToServer();
        this.needPublish();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("station", this.station);
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("txCnt", this.wirelessTxStatusList.size());
        int idx = 0;
        for (ServerWirelessTxStatus tx : this.wirelessTxStatusList.values()) {
            tx.writeToNBT(nbt, "tx" + idx);
            ++idx;
        }
        nbt.func_74768_a("rxCnt", this.wirelessRxStatusList.size());
        idx = 0;
        for (ServerWirelessRxStatus rx : this.wirelessRxStatusList.values()) {
            rx.writeToNBT(nbt, "rx" + idx);
            ++idx;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int idx;
        super.readFromNBT(nbt);
        this.station = nbt.func_74762_e("station");
        this.name = nbt.func_74779_i("name");
        int cnt = nbt.func_74762_e("txCnt");
        for (idx = 0; idx < cnt; ++idx) {
            ServerWirelessTxStatus tx = new ServerWirelessTxStatus(nbt, "tx" + idx, this);
            this.wirelessTxStatusList.put(tx.uuid, tx);
        }
        cnt = nbt.func_74762_e("rxCnt");
        for (idx = 0; idx < cnt; ++idx) {
            ServerWirelessRxStatus rx = new ServerWirelessRxStatus(nbt, "rx" + idx, this);
            this.wirelessRxStatusList.put(rx.uuid, rx);
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    void addToServer() {
        if (this.station != -1) {
            this.addedOnServer = Eln.modbusServer.add(this);
        }
    }

    void removeFromServer() {
        if (this.addedOnServer) {
            Eln.modbusServer.remove(this);
        }
        this.addedOnServer = false;
    }

    IModbusSlot getModbusSlot(int id) {
        for (IModbusSlot slot : this.mapping) {
            if (id < slot.getOffset() || id >= slot.getOffset() + slot.getSize()) continue;
            this.onActivity();
            return slot;
        }
        this.onError();
        return this.nullSlot;
    }

    @Override
    public boolean getCoil(int id) throws IllegalAddressException {
        IModbusSlot slot = this.getModbusSlot(id);
        return slot.getCoil(id -= slot.getOffset());
    }

    @Override
    public boolean getInput(int id) throws IllegalAddressException {
        IModbusSlot slot = this.getModbusSlot(id);
        return slot.getInput(id -= slot.getOffset());
    }

    @Override
    public short getInputRegister(int id) throws IllegalAddressException {
        IModbusSlot slot = this.getModbusSlot(id);
        return slot.getInputRegister(id -= slot.getOffset());
    }

    @Override
    public int getSlaveId() {
        return this.station;
    }

    @Override
    public void setCoil(int id, boolean value) {
        IModbusSlot slot = this.getModbusSlot(id);
        slot.setCoil(id -= slot.getOffset(), value);
    }

    @Override
    public void setHoldingRegister(int id, short value) {
        IModbusSlot slot = this.getModbusSlot(id);
        slot.setHoldingRegister(id -= slot.getOffset(), value);
    }

    class ModbusRtuSlowProcess
    implements IProcess {
        double sleepTimer = 0.0;

        ModbusRtuSlowProcess() {
        }

        @Override
        public void process(double time) {
            this.sleepTimer -= time;
            if (this.sleepTimer < 0.0) {
                this.sleepTimer += Utils.rand(1.2, 2.0);
                WirelessUtils.WirelessSignalSpot spot = WirelessUtils.buildSpot(ModbusRtuElement.this.getCoordonate(), null, 0);
                WirelessUtils.getTx(spot, ModbusRtuElement.this.txSet, ModbusRtuElement.this.txStrength);
            }
            for (ServerWirelessRxStatus rx : ModbusRtuElement.this.wirelessRxStatusList.values()) {
                if (rx.isConnected() == rx.connected) continue;
                rx.connected = !rx.connected;
                ModbusRtuElement.this.sendRx1Connected(rx);
            }
        }
    }
}

