/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.PhysicalInterpolator;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElementRender;
import mods.eln.node.six.SixNodeEntity;
import mods.eln.sixnode.modbusrtu.ModbusRtuDescriptor;
import mods.eln.sixnode.modbusrtu.ModbusRtuGui;
import mods.eln.sixnode.modbusrtu.WirelessRxStatus;
import mods.eln.sixnode.modbusrtu.WirelessTxStatus;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class ModbusRtuRender
extends SixNodeElementRender {
    Coordonate coord;
    PhysicalInterpolator interpolator;
    float modbusActivityTimeout = 0.0f;
    float modbusErrorTimeout = 0.0f;
    ModbusRtuDescriptor descriptor;
    HashMap<Integer, WirelessTxStatus> wirelessTxStatusList = new HashMap();
    HashMap<Integer, WirelessRxStatus> wirelessRxStatusList = new HashMap();
    int station = -1;
    String name;
    boolean boot = true;
    boolean rxTxChange = false;

    public ModbusRtuRender(SixNodeEntity tileEntity, Direction side, SixNodeDescriptor descriptor) {
        super(tileEntity, side, descriptor);
        this.descriptor = (ModbusRtuDescriptor)descriptor;
        this.interpolator = new PhysicalInterpolator(0.4f, 8.0f, 0.9f, 0.2f);
        this.coord = new Coordonate(tileEntity);
    }

    @Override
    public void draw() {
        super.draw();
        if (this.side.isY()) {
            this.front.inverse().glRotateOnX();
        } else {
            LRDU.Down.glRotateOnX();
        }
        this.descriptor.draw(this.interpolator.get(), this.modbusActivityTimeout > 0.0f, this.modbusErrorTimeout > 0.0f);
    }

    @Override
    public void refresh(float deltaT) {
        if (!Utils.isPlayerAround(this.tileEntity.func_145831_w(), this.coord.getAxisAlignedBB(0))) {
            this.interpolator.setTarget(0.0f);
        } else {
            this.interpolator.setTarget(1.0f);
        }
        this.interpolator.step(deltaT);
        if (this.modbusActivityTimeout > 0.0f) {
            this.modbusActivityTimeout -= deltaT;
        }
        if (this.modbusErrorTimeout > 0.0f) {
            this.modbusErrorTimeout -= deltaT;
        }
    }

    @Override
    public void publishUnserialize(DataInputStream stream) {
        super.publishUnserialize(stream);
        try {
            this.station = stream.readInt();
            this.name = stream.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.boot) {
            this.clientSend(9);
        }
        this.boot = false;
    }

    @Override
    public void serverPacketUnserialize(DataInputStream stream) throws IOException {
        super.serverPacketUnserialize(stream);
        switch (stream.readByte()) {
            case 1: {
                int idx;
                this.wirelessTxStatusList.clear();
                for (idx = stream.readInt(); idx > 0; --idx) {
                    WirelessTxStatus tx = new WirelessTxStatus();
                    tx.readFrom(stream);
                    this.wirelessTxStatusList.put(tx.uuid, tx);
                }
                this.wirelessRxStatusList.clear();
                for (idx = stream.readInt(); idx > 0; --idx) {
                    WirelessRxStatus rx = new WirelessRxStatus();
                    rx.readFrom(stream);
                    this.wirelessRxStatusList.put(rx.uuid, rx);
                }
                this.rxTxChange = true;
                break;
            }
            case 2: {
                WirelessTxStatus newTx = new WirelessTxStatus();
                newTx.readFrom(stream);
                this.wirelessTxStatusList.put(newTx.uuid, newTx);
                this.rxTxChange = true;
                break;
            }
            case 3: {
                WirelessRxStatus newRx = new WirelessRxStatus();
                newRx.readFrom(stream);
                this.wirelessRxStatusList.put(newRx.uuid, newRx);
                this.rxTxChange = true;
                break;
            }
            case 4: {
                this.wirelessTxStatusList.remove(stream.readInt());
                this.rxTxChange = true;
                break;
            }
            case 5: {
                this.wirelessRxStatusList.remove(stream.readInt());
                this.rxTxChange = true;
                break;
            }
            case 6: {
                WirelessRxStatus rx = this.wirelessRxStatusList.get(stream.readInt());
                if (rx == null) break;
                rx.connected = stream.readBoolean();
                break;
            }
            case 7: {
                this.modbusActivityTimeout = 0.05f;
                break;
            }
            case 8: {
                this.modbusErrorTimeout = 1.0f;
            }
        }
    }

    @Override
    public GuiScreen newGuiDraw(Direction side, EntityPlayer player) {
        return new ModbusRtuGui(player, this);
    }

    @Override
    public CableRenderDescriptor getCableRender(LRDU lrdu) {
        return Eln.instance.signalCableDescriptor.render;
    }
}

