/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mods.eln.Eln;
import mods.eln.misc.Utils;
import mods.eln.sixnode.modbusrtu.IModbusSlave;
import mods.eln.sixnode.modbusrtu.IllegalAddressException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\u0011R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmods/eln/sixnode/modbusrtu/ModbusTcpServer;", "", "port", "", "(I)V", "connections", "", "Lmods/eln/sixnode/modbusrtu/ModbusTcpServer$ConnectionHandler;", "server", "Ljava/net/ServerSocket;", "slaves", "Ljava/util/TreeMap;", "Lmods/eln/sixnode/modbusrtu/IModbusSlave;", "add", "", "slave", "destroy", "", "remove", "start", "Companion", "ConnectionHandler", "ElectricalAge-release_main"})
public final class ModbusTcpServer {
    private final ServerSocket server;
    private final List<ConnectionHandler> connections;
    private final TreeMap<Integer, IModbusSlave> slaves;
    private static final int InputBufferSize = 256;
    private static final int OutputBufferSize = 256;
    public static final Companion Companion = new Companion(null);

    public final void start() {
        new Thread(new Runnable(this){
            final /* synthetic */ ModbusTcpServer this$0;

            public final void run() {
                while (!ModbusTcpServer.access$getServer$p(this.this$0).isClosed()) {
                    Socket socket = ModbusTcpServer.access$getServer$p(this.this$0).accept();
                    if (socket == null) continue;
                    ModbusTcpServer.access$getConnections$p(this.this$0).add(this.this$0.new ConnectionHandler(socket));
                }
            }
            {
                this.this$0 = modbusTcpServer;
            }
        }).start();
    }

    public final boolean add(@NotNull IModbusSlave slave) {
        Intrinsics.checkParameterIsNotNull(slave, "slave");
        int id = slave.getSlaveId();
        if (!this.slaves.containsKey(id)) {
            this.slaves.put(slave.getSlaveId(), slave);
            return true;
        }
        return false;
    }

    @Nullable
    public final IModbusSlave remove(@NotNull IModbusSlave slave) {
        Intrinsics.checkParameterIsNotNull(slave, "slave");
        return this.slaves.remove(slave.getSlaveId());
    }

    public final void destroy() {
        this.server.close();
        Iterable $receiver$iv = this.connections;
        for (Object element$iv : $receiver$iv) {
            ConnectionHandler it = (ConnectionHandler)element$iv;
            it.destroy();
        }
    }

    public ModbusTcpServer(int port) {
        this.server = new ServerSocket();
        this.connections = new ArrayList();
        this.slaves = new TreeMap();
        if (Eln.modbusEnable) {
            try {
                this.server.bind(new InetSocketAddress(port));
            }
            catch (BindException e) {
                Utils.println("Exception while binding Modbus RTU Server. Modbus server disabled!");
                this.server.close();
                Throwable throwable = e;
                Throwable throwable2 = throwable;
                if (throwable2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                }
                throwable2.printStackTrace();
            }
            this.start();
        } else {
            this.server.close();
        }
    }

    public /* synthetic */ ModbusTcpServer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1502;
        }
        this(n);
    }

    public ModbusTcpServer() {
        this(0, 1, null);
    }

    static {
        InputBufferSize = 256;
        OutputBufferSize = ModbusTcpServer.Companion.getInputBufferSize();
    }

    @NotNull
    public static final /* synthetic */ ServerSocket access$getServer$p(ModbusTcpServer $this) {
        return $this.server;
    }

    @NotNull
    public static final /* synthetic */ List access$getConnections$p(ModbusTcpServer $this) {
        return $this.connections;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0006\u0010\u0015\u001a\u00020\u000bJ\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lmods/eln/sixnode/modbusrtu/ModbusTcpServer$ConnectionHandler;", "", "socket", "Ljava/net/Socket;", "(Lmods/eln/sixnode/modbusrtu/ModbusTcpServer;Ljava/net/Socket;)V", "inputBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "getSocket", "()Ljava/net/Socket;", "destroy", "", "handle", "output", "Ljava/io/OutputStream;", "readCoils", "slave", "Lmods/eln/sixnode/modbusrtu/IModbusSlave;", "response", "readDiscreteInputs", "readInputRegisters", "start", "writeSingleCoil", "writeSingleRegister", "ElectricalAge-release_main"})
    private final class ConnectionHandler {
        private final ByteBuffer inputBuffer;
        @NotNull
        private final Socket socket;

        public final void start() {
            new Thread(new Runnable(this){
                final /* synthetic */ ConnectionHandler this$0;

                public final void run() {
                    while (!this.this$0.getSocket().isClosed()) {
                        int size = this.this$0.getSocket().getInputStream().read(ConnectionHandler.access$getInputBuffer$p(this.this$0).array(), ConnectionHandler.access$getInputBuffer$p(this.this$0).position(), ConnectionHandler.access$getInputBuffer$p(this.this$0).remaining());
                        if (size > 0) {
                            ConnectionHandler.access$getInputBuffer$p(this.this$0).position(ConnectionHandler.access$getInputBuffer$p(this.this$0).position() + size).flip();
                            OutputStream outputStream = this.this$0.getSocket().getOutputStream();
                            Intrinsics.checkExpressionValueIsNotNull(outputStream, "socket.outputStream");
                            ConnectionHandler.access$handle(this.this$0, outputStream);
                            ConnectionHandler.access$getInputBuffer$p(this.this$0).flip();
                            continue;
                        }
                        this.this$0.getSocket().close();
                    }
                }
                {
                    this.this$0 = connectionHandler;
                }
            }).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handle(OutputStream output) {
            while (this.inputBuffer.hasRemaining()) {
                short transactionId = this.inputBuffer.getShort();
                if (this.inputBuffer.getShort() == (short)0) {
                    short remaining = this.inputBuffer.getShort();
                    if (this.inputBuffer.remaining() >= remaining) {
                        byte slaveAddress = this.inputBuffer.get();
                        byte functionCode = this.inputBuffer.get();
                        ByteBuffer response = ByteBuffer.allocate(Companion.getOutputBufferSize()).putShort(transactionId).putShort((short)0).putShort((short)0).put(slaveAddress);
                        IModbusSlave slave = (IModbusSlave)ModbusTcpServer.this.slaves.get(slaveAddress);
                        if (slave != null) {
                            synchronized (slave) {
                                Object object;
                                switch (functionCode) {
                                    case 1: {
                                        ByteBuffer byteBuffer = response;
                                        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "response");
                                        this.readCoils(slave, byteBuffer);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 2: {
                                        ByteBuffer byteBuffer = response;
                                        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "response");
                                        this.readDiscreteInputs(slave, byteBuffer);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 4: {
                                        ByteBuffer byteBuffer = response;
                                        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "response");
                                        this.readInputRegisters(slave, byteBuffer);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 5: {
                                        ByteBuffer byteBuffer = response;
                                        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "response");
                                        this.writeSingleCoil(slave, byteBuffer);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    case 6: {
                                        ByteBuffer byteBuffer = response;
                                        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "response");
                                        this.writeSingleRegister(slave, byteBuffer);
                                        object = Unit.INSTANCE;
                                        break;
                                    }
                                    default: {
                                        response.put((byte)(128 + functionCode)).put((byte)1);
                                        object = this.inputBuffer.position(this.inputBuffer.position() + remaining - 2);
                                    }
                                }
                                Unit unit = object;
                            }
                        } else {
                            response.put((byte)(128 + functionCode)).put((byte)11);
                            this.inputBuffer.position(this.inputBuffer.position() + remaining - 2);
                        }
                        response.putShort(4, (short)(response.position() - 6)).flip();
                        output.write(response.array(), 0, response.remaining());
                        output.flush();
                        continue;
                    }
                    return;
                }
                return;
            }
        }

        private final void readCoils(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short quantity = this.inputBuffer.getShort();
            try {
                if (quantity == (short)1) {
                    boolean value = slave.getCoil(address);
                    response.put((byte)1).put((byte)1).put((byte)(value ? 1 : 0));
                    return;
                }
            }
            catch (IllegalAddressException e) {
                // empty catch block
            }
            response.put((byte)129).put((byte)2);
        }

        private final void readDiscreteInputs(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short quantity = this.inputBuffer.getShort();
            try {
                if (quantity == (short)1) {
                    boolean value = slave.getInput(address);
                    response.put((byte)2).put((byte)1).put((byte)(value ? 1 : 0));
                    return;
                }
            }
            catch (IllegalAddressException e) {
                // empty catch block
            }
            response.put((byte)130).put((byte)2);
        }

        /*
         * WARNING - void declaration
         */
        private final void readInputRegisters(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short quantity = this.inputBuffer.getShort();
            try {
                void $receiver$iv;
                int size$iv;
                short s = quantity;
                Short[] result$iv = new Short[size$iv];
                boolean bl = false;
                void var9_11 = size$iv - true;
                if (bl <= var9_11) {
                    void i$iv;
                    do {
                        Short s2;
                        void var10_12 = ++i$iv;
                        void var14_14 = i$iv;
                        Short[] shortArray = result$iv;
                        shortArray[var14_14] = s2 = Short.valueOf((short)0);
                    } while (i$iv != var9_11);
                }
                Short[] data = (Short[])((Object[])result$iv);
                size$iv = 0;
                int n = quantity - 1;
                if (size$iv <= n) {
                    while (true) {
                        void i;
                        data[i] = slave.getInputRegister(address + i);
                        if (i == n) break;
                        ++i;
                    }
                }
                response.put((byte)4).put((byte)(quantity * 2));
                Object[] i = data;
                for (n = 0; n < ((void)$receiver$iv).length; ++n) {
                    void element$iv = $receiver$iv[n];
                    short it = ((Number)element$iv).shortValue();
                    response.putShort(it);
                }
                return;
            }
            catch (IllegalAddressException e) {
                response.put((byte)132).put((byte)2);
                return;
            }
        }

        private final void writeSingleCoil(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short value = this.inputBuffer.getShort();
            try {
                slave.setCoil(address, value == (short)65280);
                response.put((byte)5).putShort(address).putShort(value);
                return;
            }
            catch (IllegalAddressException e) {
                response.put((byte)133).put((byte)2);
                return;
            }
        }

        private final void writeSingleRegister(IModbusSlave slave, ByteBuffer response) {
            short address = this.inputBuffer.getShort();
            short value = this.inputBuffer.getShort();
            try {
                slave.setHoldingRegister(address, value);
                response.put((byte)6).putShort(address).putShort(value);
                return;
            }
            catch (IllegalAddressException e) {
                response.put((byte)134).put((byte)2);
                return;
            }
        }

        public final void destroy() {
            this.socket.close();
        }

        @NotNull
        public final Socket getSocket() {
            return this.socket;
        }

        public ConnectionHandler(Socket socket) {
            Intrinsics.checkParameterIsNotNull(socket, "socket");
            this.socket = socket;
            this.inputBuffer = ByteBuffer.allocate(Companion.getInputBufferSize());
            this.start();
        }

        public static final /* synthetic */ ByteBuffer access$getInputBuffer$p(ConnectionHandler $this) {
            return $this.inputBuffer;
        }

        public static final /* synthetic */ void access$handle(ConnectionHandler $this, @NotNull OutputStream output) {
            $this.handle(output);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lmods/eln/sixnode/modbusrtu/ModbusTcpServer$Companion;", "", "()V", "InputBufferSize", "", "getInputBufferSize", "()I", "OutputBufferSize", "getOutputBufferSize", "ElectricalAge-release_main"})
    public static final class Companion {
        private final int getInputBufferSize() {
            return InputBufferSize;
        }

        private final int getOutputBufferSize() {
            return OutputBufferSize;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

