/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import mods.eln.Eln;
import mods.eln.misc.Coordonate;
import mods.eln.misc.Utils;
import mods.eln.sixnode.modbusrtu.IModbusSlot;
import mods.eln.sixnode.modbusrtu.ModbusRtuElement;
import mods.eln.sixnode.modbusrtu.WirelessTxStatus;
import mods.eln.sixnode.wirelesssignal.IWirelessSignalTx;
import mods.eln.sixnode.wirelesssignal.tx.WirelessSignalTxElement;
import net.minecraft.nbt.NBTTagCompound;

public class ServerWirelessTxStatus
extends WirelessTxStatus
implements IWirelessSignalTx,
IModbusSlot {
    private ModbusRtuElement rtu;
    Coordonate coordonate;
    short getHoldingRegister_1;
    short setHoldingRegister_0;

    public ServerWirelessTxStatus(String name, int id, double value, Coordonate coordonate, int uuid, ModbusRtuElement rtu) {
        super(name, id, value, uuid);
        this.coordonate = coordonate;
        WirelessSignalTxElement.channelRegister(this);
        this.rtu = rtu;
        rtu.mapping.add(this);
    }

    public ServerWirelessTxStatus(NBTTagCompound nbt, String str, ModbusRtuElement rtu) {
        this.readFromNBT(nbt, str);
        this.coordonate = rtu.sixNode.coordonate;
        WirelessSignalTxElement.channelRegister(this);
        this.rtu = rtu;
        rtu.mapping.add(this);
    }

    @Override
    public void setName(String name) {
        WirelessSignalTxElement.channelRemove(this);
        super.setName(name);
        WirelessSignalTxElement.channelRegister(this);
    }

    public void delete() {
        this.rtu.mapping.remove(this);
        WirelessSignalTxElement.channelRemove(this);
    }

    @Override
    public Coordonate getCoordonate() {
        return this.coordonate;
    }

    @Override
    public int getRange() {
        return Eln.wirelessTxRange;
    }

    @Override
    public String getChannel() {
        return this.name;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public int getOffset() {
        return this.id;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public boolean getCoil(int id) {
        switch (id) {
            case 1: {
                return this.value >= 0.5;
            }
        }
        return false;
    }

    @Override
    public short getHoldingRegister(int id) {
        switch (id) {
            case 1: {
                float v = (float)this.getValue();
                this.getHoldingRegister_1 = Utils.modbusToShort(v, 1);
                return Utils.modbusToShort(v, 0);
            }
            case 2: {
                return this.getHoldingRegister_1;
            }
            case 3: {
                return (short)(65535.0 * this.getValue());
            }
        }
        return 0;
    }

    @Override
    public boolean getInput(int id) {
        return false;
    }

    @Override
    public short getInputRegister(int id) {
        return 0;
    }

    @Override
    public void setCoil(int id, boolean value) {
        switch (id) {
            case 1: {
                this.setValue(value ? 1.0 : 0.0);
            }
        }
    }

    @Override
    public void setHoldingRegister(int id, short value) {
        switch (id) {
            case 1: {
                this.setHoldingRegister_0 = value;
                break;
            }
            case 2: {
                this.setValue(Utils.modbusToFloat(this.setHoldingRegister_0, value));
                break;
            }
            case 3: {
                this.setValue((double)(value & 0xFFFF) / 65535.0);
            }
        }
    }

    @Override
    public void setInput(int id, boolean value) {
    }

    @Override
    public void setInputRegister(int id, short value) {
    }

    @Override
    public void writeCoil(int id, boolean value) {
        this.setCoil(id, value);
    }

    @Override
    public void writeHoldingRegister(int id, short value) {
        this.setHoldingRegister(id, value);
    }
}

