/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.modbusrtu;

import mods.eln.misc.Utils;
import mods.eln.sim.nbt.NbtElectricalGateInputOutput;
import mods.eln.sim.nbt.NbtElectricalGateOutputProcess;
import mods.eln.sixnode.modbusrtu.ModbusSlot;

public class modbusAnalogIoSlot
extends ModbusSlot {
    NbtElectricalGateInputOutput gate;
    NbtElectricalGateOutputProcess gateProcess;
    short getHoldingRegister_2;
    short getInputRegister_2;
    short setHoldingRegister_1;

    public modbusAnalogIoSlot(int offset, int range, NbtElectricalGateInputOutput gate, NbtElectricalGateOutputProcess gateProcess) {
        super(offset, range);
        this.gate = gate;
        this.gateProcess = gateProcess;
    }

    @Override
    public boolean getCoil(int id) {
        switch (id) {
            case 0: {
                return this.gateProcess.isHighImpedance();
            }
            case 1: {
                return this.gateProcess.getOutputOnOff();
            }
        }
        return false;
    }

    @Override
    public short getHoldingRegister(int id) {
        switch (id) {
            case 1: {
                double f = this.gateProcess.getOutputNormalized();
                this.getHoldingRegister_2 = Utils.modbusToShort(f, 1);
                return Utils.modbusToShort(f, 0);
            }
            case 2: {
                return this.getHoldingRegister_2;
            }
            case 3: {
                return (short)(65535.0 * this.gateProcess.getOutputNormalized());
            }
        }
        return 0;
    }

    @Override
    public boolean getInput(int id) {
        switch (id) {
            case 1: {
                return this.gate.isInputHigh();
            }
        }
        return false;
    }

    @Override
    public short getInputRegister(int id) {
        switch (id) {
            case 1: {
                double f = this.gate.getInputNormalized();
                this.getInputRegister_2 = Utils.modbusToShort(f, 1);
                return Utils.modbusToShort(f, 0);
            }
            case 2: {
                return this.getInputRegister_2;
            }
            case 3: {
                return (short)(65535.0 * this.gate.getInputNormalized());
            }
        }
        return 0;
    }

    @Override
    public void setCoil(int id, boolean value) {
        switch (id) {
            case 0: {
                this.gateProcess.setHighImpedance(value);
                break;
            }
            case 1: {
                this.gateProcess.state(value);
            }
        }
    }

    @Override
    public void setHoldingRegister(int id, short value) {
        switch (id) {
            case 1: {
                this.setHoldingRegister_1 = value;
                break;
            }
            case 2: {
                this.gateProcess.setOutputNormalized(Utils.modbusToFloat(this.setHoldingRegister_1, value));
                break;
            }
            case 3: {
                this.gateProcess.setOutputNormalized((double)(value & 0xFFFF) / 65535.0);
            }
        }
    }

    @Override
    public void setInput(int id, boolean value) {
    }

    @Override
    public void setInputRegister(int id, short value) {
    }
}

