/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powercapacitorsix;

import java.util.List;
import mods.eln.item.DielectricItem;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Obj3D;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.misc.series.ISerie;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.sixnode.powercapacitorsix.PowerCapacitorSixElement;
import mods.eln.sixnode.powercapacitorsix.PowerCapacitorSixRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class PowerCapacitorSixDescriptor
extends SixNodeDescriptor {
    private Obj3D obj;
    private Obj3D.Obj3DPart CapacitorCore;
    private Obj3D.Obj3DPart CapacitorCables;
    private Obj3D.Obj3DPart Base;
    ISerie serie;
    public double dischargeTao;

    public PowerCapacitorSixDescriptor(String name, Obj3D obj, ISerie serie, double dischargeTao) {
        super(name, PowerCapacitorSixElement.class, PowerCapacitorSixRender.class);
        this.serie = serie;
        this.dischargeTao = dischargeTao;
        this.obj = obj;
        if (obj != null) {
            this.CapacitorCables = obj.getPart("CapacitorCables");
            this.CapacitorCore = obj.getPart("CapacitorCore");
            this.Base = obj.getPart("Base");
        }
        this.voltageLevelColor = VoltageLevelColor.Neutral;
    }

    public double getCValue(int cableCount, double nominalDielVoltage) {
        if (cableCount == 0) {
            return 1.0E-6;
        }
        double uTemp = nominalDielVoltage / 50.0;
        return this.serie.getValue(cableCount - 1) / uTemp / uTemp;
    }

    @Override
    public boolean use2DIcon() {
        return true;
    }

    public double getCValue(IInventory inventory) {
        ItemStack core = inventory.func_70301_a(0);
        ItemStack diel = inventory.func_70301_a(1);
        if (core == null || diel == null) {
            return this.getCValue(0, 0.0);
        }
        return this.getCValue(core.field_77994_a, this.getUNominalValue(inventory));
    }

    public double getUNominalValue(IInventory inventory) {
        ItemStack diel = inventory.func_70301_a(1);
        if (diel == null) {
            return 10000.0;
        }
        DielectricItem desc = (DielectricItem)DielectricItem.getDescriptor(diel);
        return desc.uNominal * (double)diel.field_77994_a;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    void draw() {
        if (null != this.Base) {
            this.Base.draw();
        }
        if (null != this.CapacitorCables) {
            this.CapacitorCables.draw();
        }
        if (null != this.CapacitorCore) {
            this.CapacitorCore.draw();
        }
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type != IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.2f);
            GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.draw();
        } else {
            super.renderItem(type, item, data);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
    }

    @Override
    public LRDU getFrontFromPlace(Direction side, EntityPlayer player) {
        return super.getFrontFromPlace(side, player).left();
    }
}

