/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.sixnode.powercapacitorsix;

import java.io.DataOutputStream;
import mods.eln.Eln;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.six.SixNode;
import mods.eln.node.six.SixNodeDescriptor;
import mods.eln.node.six.SixNodeElement;
import mods.eln.node.six.SixNodeElementInventory;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.IProcess;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Capacitor;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.process.destruct.BipoleVoltageWatchdog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sixnode.powercapacitorsix.PowerCapacitorSixContainer;
import mods.eln.sixnode.powercapacitorsix.PowerCapacitorSixDescriptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class PowerCapacitorSixElement
extends SixNodeElement {
    PowerCapacitorSixDescriptor descriptor;
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    NbtElectricalLoad negativeLoad = new NbtElectricalLoad("negativeLoad");
    Capacitor capacitor = new Capacitor(this.positiveLoad, this.negativeLoad);
    Resistor dischargeResistor = new Resistor(this.positiveLoad, this.negativeLoad);
    PunkProcess punkProcess = new PunkProcess();
    BipoleVoltageWatchdog watchdog = new BipoleVoltageWatchdog().set(this.capacitor);
    double stdDischargeResistor;
    boolean fromNbt = false;
    SixNodeElementInventory inventory = new SixNodeElementInventory(2, 64, this);

    public PowerCapacitorSixElement(SixNode SixNode2, Direction side, SixNodeDescriptor descriptor) {
        super(SixNode2, side, descriptor);
        this.descriptor = (PowerCapacitorSixDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalLoadList.add(this.negativeLoad);
        this.electricalComponentList.add(this.capacitor);
        this.electricalComponentList.add(this.dischargeResistor);
        this.electricalProcessList.add(this.punkProcess);
        this.slowProcessList.add(this.watchdog);
        this.watchdog.set(new WorldExplosion(this).machineExplosion());
        this.positiveLoad.setAsMustBeFarFromInterSystem();
    }

    @Override
    public ElectricalLoad getElectricalLoad(LRDU lrdu) {
        if (lrdu == this.front.right()) {
            return this.positiveLoad;
        }
        if (lrdu == this.front.left()) {
            return this.negativeLoad;
        }
        return null;
    }

    @Override
    public ThermalLoad getThermalLoad(LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(LRDU lrdu) {
        if (lrdu == this.front.right()) {
            return 1;
        }
        if (lrdu == this.front.left()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String multiMeterString() {
        return Utils.plotVolt("U", Math.abs(this.capacitor.getU())) + Utils.plotAmpere("I", this.capacitor.getCurrent());
    }

    @Override
    public String thermoMeterString() {
        return null;
    }

    @Override
    public void initialize() {
        Eln.applySmallRs(this.positiveLoad);
        Eln.applySmallRs(this.negativeLoad);
        this.setupPhysical();
    }

    @Override
    public void inventoryChanged() {
        super.inventoryChanged();
        this.setupPhysical();
    }

    public void setupPhysical() {
        double eOld = this.capacitor.getE();
        this.capacitor.setC(this.descriptor.getCValue(this.inventory));
        this.stdDischargeResistor = this.descriptor.dischargeTao / this.capacitor.getC();
        this.watchdog.setUNominal(this.descriptor.getUNominalValue(this.inventory));
        this.punkProcess.eLegaliseResistor = Math.pow(this.descriptor.getUNominalValue(this.inventory), 2.0) / 400.0;
        if (this.fromNbt) {
            this.dischargeResistor.setR(this.stdDischargeResistor);
            this.fromNbt = false;
        } else {
            double deltaE = this.capacitor.getE() - eOld;
            this.punkProcess.eLeft += deltaE;
            if (deltaE < 0.0) {
                this.dischargeResistor.setR(this.stdDischargeResistor);
            } else {
                this.dischargeResistor.setR(this.punkProcess.eLegaliseResistor);
            }
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityPlayer, Direction side, float vx, float vy, float vz) {
        return this.onBlockActivatedRotate(entityPlayer);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74780_a("punkELeft", this.punkProcess.eLeft);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.punkProcess.eLeft = nbt.func_74769_h("punkELeft");
        if (Double.isNaN(this.punkProcess.eLeft)) {
            this.punkProcess.eLeft = 0.0;
        }
        this.fromNbt = true;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public Container newContainer(Direction side, EntityPlayer player) {
        return new PowerCapacitorSixContainer(player, this.inventory);
    }

    class PunkProcess
    implements IProcess {
        double eLeft = 0.0;
        double eLegaliseResistor;

        PunkProcess() {
        }

        @Override
        public void process(double time) {
            if (this.eLeft <= 0.0) {
                this.eLeft = 0.0;
                PowerCapacitorSixElement.this.dischargeResistor.setR(PowerCapacitorSixElement.this.stdDischargeResistor);
            } else {
                this.eLeft -= PowerCapacitorSixElement.this.dischargeResistor.getP() * time;
                PowerCapacitorSixElement.this.dischargeResistor.setR(this.eLegaliseResistor);
            }
        }
    }
}

